--
-- ChangeBodyType (must make it dynamic, not now)
--
-- author  Mythos
-- date  14/09/2015
-- www.ARM-team.gr
-- Copyright (C) ARM Team, All Rights Reserved.

changeBodyType = {};

function changeBodyType.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:load(xmlFile)
	-- Functions
	self.MPCode = SpecializationUtil.callSpecializationsFunction("MPCode");
	self.registerFillVolume = SpecializationUtil.callSpecializationsFunction("registerFillVolume");
	self.registerFillTypes = SpecializationUtil.callSpecializationsFunction("registerFillTypes");
	self.getAllowFillFromAir = Utils.overwrittenFunction(self.getAllowFillFromAir, changeBodyType.getAllowFillFromAir);
	self.playerCallback = SpecializationUtil.callSpecializationsFunction("playerCallback");
	
	-- Indexes
	self.backDischarge = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.backDischarge#index"));
	self.frontMudguards = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.frontMudguards#index"));
	self.leftSilageSide = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.leftSilageSide#index"));
	self.rightSilageSide = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.rightSilageSide#index"));
	self.strobe = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.strobe#index"));

	-- Booleans & Vars
	self.changeBody = 1;
	self.CM = false;
	self.SMG = true;
	self.livery = 1;
	self.silageSide = 1;
	
	self.strobeOn = true;
	self.strobeT1 = 250;
	self.strobeT2 = 125;
	self.counter = 0;
	self.safe = false;
	self.safe2 = false;
	
	-- Animations
	self.coverAnim = getXMLString(xmlFile, "vehicle.grainBody#coverAnimationName");
	
	-- Triggers
	self.SMGTriggers = {};
	local i=0;
	while true do
		local key = string.format("vehicle.SMGTriggers.SMGTrigger(%d)", i);
		local trigger = Utils.indexToObject(self.components,getXMLString(xmlFile, key.. "#index"));
		if trigger == nil then
			break;
		end;
		self.SMGTriggers[i+1] = {};
		self.SMGTriggers[i+1].trigger = trigger;
		self.SMGTriggers[i+1].enable = false;
		
		addTrigger(trigger, "playerCallback", self);				
		i = i + 1;
	end;
	
	-- Liveries
	self.SMGLiveries = {};
	local i=0;
	while true do
		local key = string.format("vehicle.SMGLiveries.SMGLivery(%d)", i);
		local livery = Utils.indexToObject(self.components,getXMLString(xmlFile, key.. "#index"));
		if livery == nil then
			break;
		end;
		table.insert(self.SMGLiveries, livery);
		i = i + 1;
	end;
	
	-- Body Parts
	self.grainPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainBody#part1"));
	self.silagePart1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.silageBody#part1"));
	self.silagePart2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.silageBody#part2"));
	self.manurePart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manureBody#part1"));
	
	-- Register fillVolume and capacity
	self.grainIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grainBody#index"));
	self.silageIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.silageBody#index"));
	self.manureIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manureBody#index"));
	
	self.grainCapacity = getXMLFloat(xmlFile, "vehicle.grainBody#capacity");
	self.silageCapacity = getXMLFloat(xmlFile, "vehicle.silageBody#capacity");
	self.manureCapacity = getXMLFloat(xmlFile, "vehicle.manureBody#capacity");
	
	self.capacity = self.grainCapacity;
	self:registerFillVolume(self.grainIndex, self.capacity);

	-- Register fillTypes
	self.allFillTypes = getXMLString(xmlFile, "vehicle.allFillTypes#fillTypes");
	self.grainFillTypes = getXMLString(xmlFile, "vehicle.grainBody#fillTypes");
	self.silageFillTypes = getXMLString(xmlFile, "vehicle.silageBody#fillTypes");
	self.manureFillTypes = getXMLString(xmlFile, "vehicle.manureBody#fillTypes");
	
	self:registerFillTypes(self.grainFillTypes);

end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:registerFillVolume(index, capacity)
	local num = table.getn(self.fillVolumes);
	for i=1, num do
		self.fillVolumes[i] = nil;
	end;
	
	local fillVolume = {};
	fillVolume.baseNode = index;
	fillVolume.volume = createFillPlaneShape(fillVolume.baseNode, "fillPlane", capacity, 1, math.rad(35), math.rad(35), 0.9, true);
	fillVolume.scrollSpeedDischarge = { Utils.getVectorFromString("0 0 0") };
	fillVolume.scrollSpeedLoad = { Utils.getVectorFromString("0 0 0") };
	for i=1,3 do
		fillVolume.scrollSpeedDischarge[i] = fillVolume.scrollSpeedDischarge[i] / 1000;
		fillVolume.scrollSpeedLoad[i] = fillVolume.scrollSpeedLoad[i] / 1000;
	end;
	fillVolume.uvPosition = {0, 0, 0};
	if fillVolume.volume ~= nil and fillVolume.volume ~= 0 then
		link(fillVolume.baseNode, fillVolume.volume);
		table.insert(self.fillVolumes, fillVolume);
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:registerFillTypes(fillTypes)
	
	local types = Utils.splitString(" ", self.allFillTypes);
	for k,v in pairs(types) do
		local allfillType = Fillable.fillTypeNameToInt[v];
		if allfillType ~= nil then
			self.fillTypes[allfillType] = nil;
		end;
	end;

	if fillTypes ~= nil then
		local types = Utils.splitString(" ", fillTypes);
		for k,v in pairs(types) do
			local fillType = Fillable.fillTypeNameToInt[v];
			if fillType ~= nil then
				self.fillTypes[fillType] = true;
			else
				print("Warning: '"..self.configFileName.. "' has invalid fillType '"..v.."'.");
			end;
		end;
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:delete()
	for i,j in pairs(self.SMGTriggers) do
		if j.trigger ~= nil then
			removeTrigger(j.trigger);
		end;
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:mouseEvent(posX, posY, isDown, isUp, button)
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:keyEvent(unicode, sym, modifier, isDown)
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:update(dt)
	
	local enable = false;
	local id = 0;
	for i,j in pairs(self.SMGTriggers) do
		if j.enable then
			id = i;
			enable = true;
			break;
		end;
	end;
	
	if enable then
		if id==1 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PS1823H_SMG"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:MPCode(6, not self.SMG);
			end;
		elseif id==2 then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PS1823H_LIV"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self.livery = self.livery+1;
				if self.livery >=4 then
					self.livery = 1;
				end;
				self:MPCode(7, nil, self.livery); -- Livery number
			end;
		end;
	end;
	
	if self:getIsActiveForInput() and self:getIsActive() then
		
		if self.fillLevel == 0 and self.tipState == 0 then
			if InputBinding.hasEvent(InputBinding.PS1823H_BODY_MODE) then
				self.changeBody = self.changeBody + 1;
			
				if self.changeBody == 1  then
					self:MPCode(1);
				elseif self.changeBody == 2  then
					self:MPCode(2);
				elseif self.changeBody == 3  then
					self:MPCode(3);
				elseif self.changeBody == 4 then
					self.changeBody = 1;
					self:MPCode(1);
				end;
			end;
		end;
		
		if self.changeBody == 1 and self.tipState == 0 then
			if InputBinding.hasEvent(InputBinding.TOGGLE_COVER) then
				self:MPCode(4, not self.CM);
			end;
		end;
		
		if self.changeBody == 2 and self.tipState == 0 then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
				self.silageSide = self.silageSide+1;
				if self.silageSide >=5 then
					self.silageSide = 1;
				end;
				self:MPCode(8, nil, self.silageSide);
			end;
		end;
		
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:updateTick(dt)

	if self.attacherVehicle ~= nil then
		if (self.attacherVehicle:getIsActiveForInput(false) and self.attacherVehicle.beaconLightsActive) or (g_gui.currentGuiName == "ChatDialog" and self.attacherVehicle.beaconLightsActive) then
			self.safe2 = false;
			if self.counter < 2 then
				if not self.safe then
					self:MPCode(9, self.strobeOn);
					self.safe = true;
				end;
				
				self.strobeT1 = self.strobeT1 - dt;
				if self.strobeT1 < 0 then
					self.strobeOn = not self.strobeOn;
					self.counter = self.counter + 1;
					self.safe = false;
					self.strobeT1 = 250;
				end;
			elseif self.counter >= 2 then
				if not self.safe then
					self:MPCode(9, self.strobeOn);
					self.safe = true;
				end;
				
				self.strobeT2 = self.strobeT2 - dt;
				if self.strobeT2 < 0 then
					self.strobeOn = not self.strobeOn;
					self.counter = self.counter + 1;
					self.safe = false;
					self.strobeT2 = 125;
					if self.counter > 6 then
						self.counter = 0;
					end;
				end;
			end;
		else
			if not self.safe2 then
				self:MPCode(9, false);
				self.safe2 = true;
			end;
			self.strobeOn = true;
			self.strobeT1 = 250;
			self.strobeT2 = 125;
			self.counter = 0;
			self.safe = false;
		end;
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:onDetach()
	self:MPCode(9, false);
	self.strobeOn = true;
	self.strobeT1 = 250;
	self.strobeT2 = 125;
	self.counter = 0;
	self.safe = false;
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:MPCode(mode, state, a1, noEventSend)
	changeBodyTypeEvent.sendEvent(self, mode, state, a1, noEventSend);
	--______________________________________________________________________________
	if mode == 1 then
	--_________________________________ GRAIN BODY __________________________________
		self.changeBody = 1;
		self.capacity = self.grainCapacity;
		self:registerFillVolume(self.grainIndex, self.capacity);
		self:registerFillTypes(self.grainFillTypes);
		
		setTranslation(self.backDischarge, 0, 3, 2.5);
		
		setVisibility(self.grainPart, true);
		setVisibility(self.silagePart1, false);
		setVisibility(self.silagePart2, false);
		setVisibility(self.manurePart, false);
	--______________________________________________________________________________
	elseif mode == 2 then
	--_________________________________ SILAGE BODY__________________________________
		self.changeBody = 2;
		self.capacity = self.silageCapacity;
		self:registerFillVolume(self.silageIndex, self.capacity);
		self:registerFillTypes(self.silageFillTypes);
		
		setTranslation(self.backDischarge, 0, 3, -4.386);
		
		setVisibility(self.grainPart, false);
		setVisibility(self.silagePart1, true);
		setVisibility(self.silagePart2, true);
		setVisibility(self.manurePart, false);
	--______________________________________________________________________________
	elseif mode == 3 then
	--_________________________________ MANURE BODY_________________________________
		self.changeBody = 3;
		self.capacity = self.manureCapacity;
		self:registerFillVolume(self.manureIndex, self.capacity);
		self:registerFillTypes(self.manureFillTypes);
		
		setTranslation(self.backDischarge, 0, 3, 2.5);
		
		setVisibility(self.grainPart, false);
		setVisibility(self.silagePart1, false);
		setVisibility(self.silagePart2, false);
		setVisibility(self.manurePart, true);
	--______________________________________________________________________________
	elseif mode == 4 then
	--_________________________________ COVER MODE __________________________________
		if state then
			self:playAnimation(self.coverAnim, 1, nil, true);
			self.CM = true;
		else
			self:playAnimation(self.coverAnim, -1, nil, true);
			self.CM = false;
		end;
	--______________________________________________________________________________
	elseif mode == 5 then
	--_________________________________ COVER MODE __________________________________
		if state then
			self:playAnimation(self.coverAnim, 100, nil, true);
			self.CM = true;
		else
			self:playAnimation(self.coverAnim, -100, nil, true);
			self.CM = false;
		end;
	--______________________________________________________________________________
	elseif mode == 6 then
	--_________________________________ MUDGUARDS MODE _____________________________
		if state then
			setVisibility(self.frontMudguards, true);
			self.SMG = true;
		else
			setVisibility(self.frontMudguards, false);
			self.SMG = false;
		end;
	--______________________________________________________________________________
	elseif mode == 7 then
	--_________________________________ LIVERIES MODE _____________________________
		local num = table.getn(self.SMGLiveries);
		for i=1,num do
			setVisibility(self.SMGLiveries[i], false);
		end;
		setVisibility(self.SMGLiveries[a1], true);
		setVisibility(self.SMGLiveries[a1+3], true);
		setVisibility(self.SMGLiveries[a1+6], true);
		self.livery = a1;
	--______________________________________________________________________________
	elseif mode == 8 then
	--_________________________________ SILAGE SIDES MODE ___________________________
		if a1==1 then	-- left side
			setVisibility(self.leftSilageSide, true);
			setVisibility(self.rightSilageSide, false);
			self.silageSide = 1;
		elseif a1==2 then	-- right side
			setVisibility(self.leftSilageSide, false);
			setVisibility(self.rightSilageSide, true);
			self.silageSide = 2;
		elseif a1==3 then	-- both sides
			setVisibility(self.leftSilageSide, true);
			setVisibility(self.rightSilageSide, true);
			self.silageSide = 3;
		elseif a1==4 then	-- no sides
			setVisibility(self.leftSilageSide, false);
			setVisibility(self.rightSilageSide, false);
			self.silageSide = 4;
		end;
	--______________________________________________________________________________
	elseif mode == 9 then
	--____________________________________ STROBE MODE _____________________________
		if state then
			setVisibility(self.strobe, true);
		else
			setVisibility(self.strobe, false);
		end;
	end;

end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:draw()	
	
	if self.fillLevel == 0 and self.tipState == 0 then
		if self.changeBody == 1  then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PS1823H_SILAGE_BODY"), self.typeDesc), InputBinding.PS1823H_BODY_MODE);
		elseif self.changeBody == 2  then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PS1823H_MANURE_BODY"), self.typeDesc), InputBinding.PS1823H_BODY_MODE);
		elseif self.changeBody == 3  then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PS1823H_GRAIN_BODY"), self.typeDesc), InputBinding.PS1823H_BODY_MODE);
		end;
	end;
	if self.changeBody == 1 and self.tipState == 0 then
		if self.CM then
			g_currentMission:addHelpButtonText(g_i18n:getText("OPEN_COVER"), InputBinding.TOGGLE_COVER);
		else	
			g_currentMission:addHelpButtonText(g_i18n:getText("CLOSE_COVER"), InputBinding.TOGGLE_COVER);
		end;
	end;
	if self.changeBody == 2 and self.tipState == 0 then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PS1823H_SILAGE_SIDES"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA4);
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.changeBody = Utils.getNoNil(getXMLInt(xmlFile, key.."#changeBody"),1);
		self.CM = Utils.getNoNil(getXMLBool(xmlFile, key.."#CM"),false);
		self.SMG = Utils.getNoNil(getXMLBool(xmlFile, key.."#SMG"),true);
		self.livery = Utils.getNoNil(getXMLInt(xmlFile, key.."#livery"),1);
		self.silageSide = Utils.getNoNil(getXMLInt(xmlFile, key.."#silageSide"),1);
		
		if self.CM then
			self:MPCode(5, self.CM);
		end;
		
		if not self.SMG then
			self:MPCode(6, self.SMG);
		end;
		
		if self.changeBody ~=nil and self.changeBody ~=1 then
			self:MPCode(self.changeBody);
		end;
		
		self:MPCode(7, nil, self.livery);
		self:MPCode(8, nil, self.silageSide);
		
		local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
		local fillType = getXMLString(xmlFile, key.."#fillType");
		if fillLevel ~= nil and fillType ~= nil then
			local fillTypeInt = Fillable.fillTypeNameToInt[fillType];
			if fillTypeInt ~= nil then
				if self.changeBody ~=1 then
					local fillSourceStruct = {x=0,y=0,z=0, d1x=0,d1y=0,d1z=0, d2x=0,d2y=0,d2z=0};
				end;
				self:setFillLevel(fillLevel, fillTypeInt, false, fillSourceStruct);
			end;
		end;
	
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'changeBody="'..tostring(self.changeBody)..
	'" CM="'..tostring(self.CM)..
	'" SMG="'..tostring(self.SMG)..
	'" livery="'..tostring(self.livery)..
	'" silageSide="'..tostring(self.silageSide)..'"';

	local nodes = nil;
	
	return attributes,nodes;
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:readStream(streamId, connection)
	self.changeBody = streamReadInt32(streamId);
	if self.changeBody ~=nil and self.changeBody ~=1 then
		self:MPCode(self.changeBody, nil, nil, true);
	end;
	self.CM = streamReadBool(streamId);
	if self.CM then
		self:MPCode(5, self.CM, nil, true);
	end;
	self.SMG = streamReadBool(streamId);
	self:MPCode(6, self.SMG, nil, true);
	
	self.livery = streamReadInt32(streamId);
	self:MPCode(7, nil, self.livery, true);
	
	self.silageSide = streamReadInt32(streamId);
	self:MPCode(8, nil, self.silageSide, true);
	
	local fillLevel = streamReadFloat32(streamId);
	local fillType = streamReadUIntN(streamId, Fillable.sendNumBits);
	if self.changeBody ~=1 then
		local fillSourceStruct = {x=0,y=0,z=0, d1x=0,d1y=0,d1z=0, d2x=0,d2y=0,d2z=0};
	end;
	self:setFillLevel(fillLevel, fillType, false, fillSourceStruct);
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.changeBody);
	streamWriteBool(streamId, self.CM);
	streamWriteBool(streamId, self.SMG);
	streamWriteInt32(streamId, self.livery);
	streamWriteInt32(streamId, self.silageSide);
	streamWriteFloat32(streamId, self.fillLevel);
	streamWriteUIntN(streamId, self.currentFillType, Fillable.sendNumBits);
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:getAllowFillFromAir(superFunc)
	if self.CM then
		return false;
	end
	return superFunc(self);
end;

--________________________________________________________________________________________________________________________________________________________
function changeBodyType:playerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	
	local id = 0;
	for i,j in pairs(self.SMGTriggers) do
		if j.trigger == triggerId then
			id = i;
			break;
		end;
	end;
	
	if id ~= 0 then
		if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			self.SMGTriggers[id].enable = true;
		elseif onLeave then
			self.SMGTriggers[id].enable = false;
		end;
	end
	
end;

--**********************************************************************************************************************************************************************************
changeBodyTypeEvent = {};
changeBodyTypeEvent_mt = Class(changeBodyTypeEvent, Event);

InitEventClass(changeBodyTypeEvent, "changeBodyTypeEvent");

function changeBodyTypeEvent:emptyNew()
    local self = Event:new(changeBodyTypeEvent_mt);
    self.className="changeBodyTypeEvent";
    return self;
end;

function changeBodyTypeEvent:new(vehicle, mode, state, a1)
    local self = changeBodyTypeEvent:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
	self.a1 = a1;
    return self;
end;

function changeBodyTypeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
	self.a1 = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function changeBodyTypeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
	streamWriteInt32(streamId, self.a1);
end;

function changeBodyTypeEvent:run(connection)
	self.vehicle:MPCode(self.mode, self.state, self.a1, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(changeBodyTypeEvent:new(self.vehicle, self.mode, self.state, self.a1), nil, connection, self.vehicle);
    end;
end;

function changeBodyTypeEvent.sendEvent(vehicle, mode, state, a1, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(changeBodyTypeEvent:new(vehicle, mode, state, a1), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(changeBodyTypeEvent:new(vehicle, mode, state, a1));
		end;
	end;
end;