--
-- sprayerApplicationRate
--
-- author: upsidedown
-- date: 22.05.2013
-- 
--


sprayerApplicationRate = {};

function sprayerApplicationRate.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function sprayerApplicationRate:load(xmlFile)
	
	self.sprayerWidth = 1;
	
	self.sprayerHUD = Overlay:new("Sprayeroverlay", Utils.getFilename("SprayerARHud.dds", self.baseDirectory.."texture/"),  0.9, 0.255, 0.10, 0.04);
	self.sprayerAppRate = 0;
	self.sprayerLastPosition = {}
	self.sprayerLastPos = {}
	self.sprayerLastPos.x = 0;
	self.sprayerLastPos.z = 0;	
end;

function sprayerApplicationRate:delete()
	
end;

function sprayerApplicationRate:mouseEvent(posX, posY, isDown, isUp, button)
end;

function sprayerApplicationRate:keyEvent(unicode, sym, modifier, isDown)
end;



function sprayerApplicationRate:updateTick(dt)
	
end


function sprayerApplicationRate:update(dt)

	if self:getIsActive() then
	
		local xmin = 200;
		local xmax = -200;
		for _,workAreas in pairs(self.workAreas) do
			if self:getIsAreaActive(workAreas) then
								
				local x1,y1,z1 = getWorldTranslation(workAreas.start)
				local x2,y2,z2 = getWorldTranslation(workAreas.width)
				local x3,y3,z3 = getWorldTranslation(workAreas.height)
				local lx1,ly1,lz1 = worldToLocal(self.rootNode,x1,y1,z1)
				local lx2,ly2,lz2 = worldToLocal(self.rootNode,x2,y2,z2)
				local lx3,ly3,lz3 = worldToLocal(self.rootNode,x3,y3,z3)
				
				if lx1 < xmin then
					xmin = lx1;
				end
				if lx1 > xmax then
					xmax = lx1;
				end
				if lx2 < xmin then
					xmin = lx2;
				end
				if lx2 > xmax then
					xmax = lx2;
				end
				if lx3 < xmin then
					xmin = lx3;
				end
				if lx3 > xmax then
					xmax = lx3;
				end
			end
		end
			
			
		self.sprayerWidth = xmax-xmin;
		
		if self.sprayerWidth < 0 then
			self.sprayerWidth = 0;
		end;
		
		local kmh = 0;					
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.lastSpeed ~= nil and self.attacherVehicle.speedDisplayScale ~= nil then
				kmh = self.attacherVehicle.lastSpeed*self.attacherVehicle.speedDisplayScale*3600;
				if kmh < 0.1 then
					kmh = 0;
				end;
			end;
		end;
		
		local fillType = self.currentFillType;
		local litersPerSecond = 0;
		if fillType ~= Fillable.FILLTYPE_UNKNOWN then												
			-- if self.sprayLitersPerSecondMax[fillType] == nil then
				-- self.sprayLitersPerSecondMax[fillType] = self.sprayLitersPerSecond[fillType];							
			-- end;						
			-- self.sprayLitersPerSecond[fillType] = self.pumpState * self.sprayLitersPerSecondMax[fillType];
			litersPerSecond = self.sprayLitersPerSecond[fillType];
		end;
		
		self.sprayerAppRate = 0.0;
		if self.allowsSpraying then
			if self.isTurnedOn then					
				self.sprayerAppRate = litersPerSecond*36.0/(kmh*self.sprayerWidth);
			end;
		end;

	end;
end;



function sprayerApplicationRate:draw()
	
	self.sprayerHUD:render();
	setTextAlignment(RenderText.ALIGN_RIGHT); 
	setTextBold(true);
	local r = .8;
	local g = .8;
	local b = .8;
	if self.sprayerAppRate > 0 then
		r = 0.8;
		g = 0;
		b = 0;

		if self.sprayerAppRate > 6 and self.sprayerAppRate < 32 then
			r = 0.8;
			g = .8;
			b = 0;
		end
		if self.sprayerAppRate > 9 and self.sprayerAppRate < 28 then
			r = 0;
			g = .8;
			b = 0;
		end
	end
	
	
	setTextColor(r,g,b,1);
	if self.sprayerAppRate ~= nil then
		renderText(.9+ 0.085,0.255 + 0.010,0.022, string.format("%3.1f",self.sprayerAppRate));
	end
	
	setTextAlignment(RenderText.ALIGN_LEFT); 
	setTextBold(false);
	setTextColor(1,1,1,1);
	
end;


function sprayerApplicationRate:onDeactivate()
	
end;