-- Specialization for Vogelsang VX186-520 rotary lobe pump with duoShift configuration and power shaft switcher
--
-- upsidedown 18.06.2013

VX186duoShift = {};



function VX186duoShift.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Sprayer, specializations);
end;

function VX186duoShift:load(xmlFile)
	--self.setAttacherVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setAttacherVehicleRpmUp");

	self.VX186duoShift_PTO = false; --start with 1000
	self.VX186duoShift_duoShift = false; --start with high rate
end;

function VX186duoShift:delete()
end;

function VX186duoShift:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VX186duoShift:keyEvent(unicode, sym, modifier, isDown)
end;

function VX186duoShift:update(dt)

	if self:getIsActiveForInput() then
		local needEvent = false;
		if InputBinding.hasEvent(InputBinding.VX186duoShift_PTO) then					
			self.VX186duoShift_PTO = not self.VX186duoShift_PTO;
			needEvent = true;
		end;
		if InputBinding.hasEvent(InputBinding.VX186duoShift_duoShift) then					
			self.VX186duoShift_duoShift = not self.VX186duoShift_duoShift;
			needEvent = true;
		end;
		if needEvent then
			if g_server ~= nil then
				g_server:broadcastEvent(VX186_Event:new(self, self.VX186duoShift_PTO,self.VX186duoShift_duoShift), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(VX186_Event:new(self, self.VX186duoShift_PTO,self.VX186duoShift_duoShift));
			end;
		end				
	end;
end;


function VX186duoShift:updateTick(dt)

	if self:getIsActive() then
		local fillType = self.currentFillType;
		if fillType ~= Fillable.FILLTYPE_UNKNOWN then												
			local pumpRate = 75.2;
			if self.VX186duoShift_PTO then
				pumpRate = 0.75*pumpRate;
			end;
			if self.VX186duoShift_duoShift then
				pumpRate = 0.66*pumpRate;
			end;
			
			
			
						
			
			local motorFactor = 1;
			if self.attacherVehicle.motor ~= nil then
				if self.attacherVehicle.isMotorStarted then
					if self.attacherVehicle.motor.lastMotorRpm ~= nil then
						self.ptoInput.rotSpeed = 1050*self.attacherVehicle.motor.lastMotorRpm/2000;
						if self.VX186duoShift_PTO then
							self.ptoInput.rotSpeed = self.ptoInput.rotSpeed * .54
						end
						
						
						local rpmFac = 4; 
						if false then --make connection to universialGearBox here
							rpmFac = 1;
						end;
						motorFactor = math.min(rpmFac*self.attacherVehicle.motor.lastMotorRpm,2200*rpmFac)/2200;
						pumpRate = pumpRate * motorFactor;
						
					else
						pumpRate = 0;
					end;
				else
					pumpRate = 0;
				end;
			else
				pumpRate = 0;
			end;
			self.sprayLitersPerSecond[fillType] = pumpRate; 
			
			
			local timeFac = Utils.getNoNil(g_currentMission.missionStats.timeScale,1);
			
			
			self.fillLitersPerSecond = timeFac*pumpRate/motorFactor; --pump rate calculated at max motor rpm.. better solution in the future
			
		end;	
	end;
end;

function VX186duoShift:readStream(streamId, connection)
    self.VX186duoShift_duoShift = streamReadBool(streamId);
	self.VX186duoShift_PTO = streamReadBool(streamId);
end;

function VX186duoShift:writeStream(streamId, connection)
   streamWriteBool(streamId, self.VX186duoShift_duoShift);
   streamWriteBool(streamId, self.VX186duoShift_PTO);
end;

function VX186duoShift:draw()
	if self.VX186duoShift_duoShift then
		g_currentMission:addHelpButtonText(string.format("DuoShift: Umwaelzen/Verteilen"), InputBinding.VX186duoShift_duoShift);
	else
		g_currentMission:addHelpButtonText(string.format("DuoShift: Saugen/Maximal"), InputBinding.VX186duoShift_duoShift);
	end
	if self.VX186duoShift_PTO then
		g_currentMission:addHelpButtonText(string.format("Zapfwelle: 540E"), InputBinding.VX186duoShift_PTO);
	else
		g_currentMission:addHelpButtonText(string.format("Zapfwelle: 1000"), InputBinding.VX186duoShift_PTO);
	end
end;

function VX186duoShift:getSaveAttributesAndNodes(nodeIdent)
	local attributes = "";
	if self.VX186duoShift_duoShift ~= nil then
		attributes = 'VX186_duo="'..tostring(self.VX186duoShift_duoShift)..'" '		
		attributes = attributes..'VX186_pto="'..tostring(self.VX186duoShift_PTO)..'" '			
	end
	return attributes
end;


function VX186duoShift:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local duo = getXMLBool(xmlFile, key.."#VX186_duo");
		if duo ~= nil then
			self.VX186duoShift_duoShift = duo;
			
			local pto = getXMLBool(xmlFile, key.."#VX186_pto");
			self.VX186duoShift_PTO = pto;
		end;
	
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end



-- function VX186duoShift:onAttach()
	-- self.attacherVehicle.saveMinRpm = self.attacherVehicle.motor.minRpm;
-- end;


-- function VX186duoShift:setAttacherVehicleRpmUp(dt, isActive)
	-- if self.attacherVehicle.saveMinRpm ~= 0 and self.attacherVehicle.motor ~= nil then
		-- if dt ~= nil then
			-- if isActive == true then
				-- self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt/2), -800);
			-- else
				-- self.attacherVehicle.motor.minRpm = self.attacherVehicle.saveMinRpm --math.min(self.attacherVehicle.motor.minRpm+(dt*2), self.attacherVehicle.saveMinRpm);
			-- end;
		-- else
			-- self.attacherVehicle.motor.minRpm = self.attacherVehicle.saveMinRpm;
		-- end;
		-- if self.attacherVehicle.isMotorStarted then
			-- local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
			-- self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			-- g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			-- g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		-- end;
	-- end;
-- end;


VX186_Event = {};
  VX186_Event_mt = Class(VX186_Event, Event);
  
  InitEventClass(VX186_Event, "VX186_Event");
  
  function VX186_Event:emptyNew()
      local self = Event:new(VX186_Event_mt);
      return self;
  end;
  
  function VX186_Event:new(object,pto,duo)
      local self = VX186_Event:emptyNew()
      self.pto = pto;
	  self.duo = duo;
	  
      self.object = object;
      return self;
  end;
  
  function VX186_Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.pto = streamReadFloat32(streamId);
	  self.duo = streamReadFloat32(streamId);
	  
	  self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function VX186_Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteFloat32(streamId, self.pto);
	  streamWriteFloat32(streamId, self.duo);
  end;
  
  function VX186_Event:run(connection)
	  self.object.VX186duoShift_PTO = self.pto;
	  self.object.VX186duoShift_duoShift = self.duo;
	  
      if not connection:getIsServer() then
          g_server:broadcastEvent(VX186_Event:new(self.object, self.pto, self.duo), nil, connection, self.object);
      end;
  end;