--
-- zil
--
-- M@D Author  StarT,     Edit: werik, Silak_68 (04/08/2013)
-- M@D date  16.12.2011
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --


zil = {}

function zil.prerequisitesPresent(specializations)
	Vehicle.registerJointType("telehandler");
    return true ;
end;

function zil:load(xmlFile)

    self.fan = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fan#index"));
    self.fanRotation = 0;

local rotationPartNodeKmh1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	local rotationPartNodeTanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;

local rotationPartNodetahometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tahometr#index"));
    if rotationPartNodetahometr ~= nil then
        self.rotationParttahometr = {};
        self.rotationParttahometr.node = rotationPartNodetahometr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#minRot"));
        self.rotationParttahometr.minRot = {};
        self.rotationParttahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#maxRot"));
        self.rotationParttahometr.maxRot = {};
        self.rotationParttahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParttahometr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr#rotTime"), 2)*1000;
        self.rotationParttahometr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr#touchRotLimit"), 10));
    end;
	
	self.drivingParticles = {};
    if self.isClient then
        local i=0;
        while true do
            local key = string.format("vehicle.drivingParticles.drivingParticle(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
                break;
            end;
            local particle = {};
            particle.ps = {};
            Utils.loadParticleSystem(xmlFile, particle.ps, key, self.components, false, nil, self.baseDirectory);
            if table.getn(particle.ps) > 0 then
                particle.minSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minSpeed"), 2)/3600;
                particle.maxSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxSpeed"), 40)/3600;
                particle.minScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minScale"), 0.2);
                particle.maxScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxScale"), 1);
                particle.direction = Utils.getNoNil(getXMLFloat(xmlFile, key.."#direction"), 1);
				particle.wheel = getXMLInt(xmlFile, key .. "#wheel");
				particle.lastScale = 0;
                table.insert(self.drivingParticles, particle);
            end;

            i = i+1;
        end;
    end;
	self.drivingParticleThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingParticles#threshold"), 0.005);

-- Wiper

	self.wiper1Active = false;	
    self.wiper2Active = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayWischer1 = 0;
    self.delayWischer2 = 0;
    self.delayOn = 0;
    self.delayOff = 0;
    self.deltafo = 0;
	local wiper1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper1#index"));
    if wiper1Node ~= nil then
        self.wiper1 = {};
        self.wiper1.node = wiper1Node;
    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper1#minRot"));
        self.wiper1.minRot = {};
        self.wiper1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper1#maxRot"));
        self.wiper1.maxRot = {};
        self.wiper1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.wiper1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper1#rotTime"), 2)*1000;
        self.wiper1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper1#touchRotLimit"), 10));
    end;
	
local wiper2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper2#index"));
    if wiper2Node ~= nil then
        self.wiper2 = {};
        self.wiper2.node = wiper2Node;
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper2#minRot"));
        self.wiper2.minRot = {};
        self.wiper2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wiper2#maxRot"));
        self.wiper2.maxRot = {};
        self.wiper2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wiper2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wiper2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.wiper2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper2#rotTime"), 2)*1000;
        self.wiper2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wiper2#touchRotLimit"), 10));
    end;

	local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
    end;

	local rotationNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
        self.rotation2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#touchRotLimit"), 10));
    end;

-- manometr break

 local rotationPartNodemanometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr#index"));
    if rotationPartNodemanometr ~= nil then
        self.rotationPartmanometr = {};
        self.rotationPartmanometr.node = rotationPartNodemanometr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr#minRot"));
        self.rotationPartmanometr.minRot = {};
        self.rotationPartmanometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr#maxRot"));
        self.rotationPartmanometr.maxRot = {};
        self.rotationPartmanometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr#rotTime"), 2)*1000;
        self.rotationPartmanometr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr#touchRotLimit"), 10));
    end;
local rotationPartNodemanometr0 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr0#index"));
    if rotationPartNodemanometr0 ~= nil then
        self.rotationPartmanometr0 = {};
        self.rotationPartmanometr0.node = rotationPartNodemanometr0;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr0#minRot"));
        self.rotationPartmanometr0.minRot = {};
        self.rotationPartmanometr0.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr0.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr0.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr0#maxRot"));
        self.rotationPartmanometr0.maxRot = {};
        self.rotationPartmanometr0.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr0.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr0.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr0.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr0#rotTime"), 2)*1000;
        self.rotationPartmanometr0.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr0#touchRotLimit"), 10));
    end;
local rotationPartNodemanometr1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr1#index"));
    if rotationPartNodemanometr1 ~= nil then
        self.rotationPartmanometr1 = {};
        self.rotationPartmanometr1.node = rotationPartNodemanometr1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr1#minRot"));
        self.rotationPartmanometr1.minRot = {};
        self.rotationPartmanometr1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr1#maxRot"));
        self.rotationPartmanometr1.maxRot = {};
        self.rotationPartmanometr1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr1#rotTime"), 2)*1000;
        self.rotationPartmanometr1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr1#touchRotLimit"), 10));
    end;
local rotationPartNodemanometr2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr2#index"));
    if rotationPartNodemanometr2 ~= nil then
        self.rotationPartmanometr2 = {};
        self.rotationPartmanometr2.node = rotationPartNodemanometr2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr2#minRot"));
        self.rotationPartmanometr2.minRot = {};
        self.rotationPartmanometr2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr2#maxRot"));
        self.rotationPartmanometr2.maxRot = {};
        self.rotationPartmanometr2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr2#rotTime"), 2)*1000;
        self.rotationPartmanometr2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr2#touchRotLimit"), 10));
    end;
local rotationPartNodemanometr3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr3#index"));
    if rotationPartNodemanometr3 ~= nil then
        self.rotationPartmanometr3 = {};
        self.rotationPartmanometr3.node = rotationPartNodemanometr3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr3#minRot"));
        self.rotationPartmanometr3.minRot = {};
        self.rotationPartmanometr3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr3#maxRot"));
        self.rotationPartmanometr3.maxRot = {};
        self.rotationPartmanometr3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr3#rotTime"), 2)*1000;
        self.rotationPartmanometr3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr3#touchRotLimit"), 10));
    end;
local rotationPartNodemanometr4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr4#index"));
    if rotationPartNodemanometr4 ~= nil then
        self.rotationPartmanometr4 = {};
        self.rotationPartmanometr4.node = rotationPartNodemanometr4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr4#minRot"));
        self.rotationPartmanometr4.minRot = {};
        self.rotationPartmanometr4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr4#maxRot"));
        self.rotationPartmanometr4.maxRot = {};
        self.rotationPartmanometr4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr4#rotTime"), 2)*1000;
        self.rotationPartmanometr4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr4#touchRotLimit"), 10));
    end;
local rotationPartNodemanometr5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr5#index"));
    if rotationPartNodemanometr5 ~= nil then
        self.rotationPartmanometr5 = {};
        self.rotationPartmanometr5.node = rotationPartNodemanometr5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr5#minRot"));
        self.rotationPartmanometr5.minRot = {};
        self.rotationPartmanometr5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr5#maxRot"));
        self.rotationPartmanometr5.maxRot = {};
        self.rotationPartmanometr5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr5#rotTime"), 2)*1000;
        self.rotationPartmanometr5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr5#touchRotLimit"), 10));
    end;
local rotationPartNodemanometr6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manometr6#index"));
    if rotationPartNodemanometr6 ~= nil then
        self.rotationPartmanometr6 = {};
        self.rotationPartmanometr6.node = rotationPartNodemanometr6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr6#minRot"));
        self.rotationPartmanometr6.minRot = {};
        self.rotationPartmanometr6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.manometr6#maxRot"));
        self.rotationPartmanometr6.maxRot = {};
        self.rotationPartmanometr6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmanometr6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmanometr6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmanometr6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr6#rotTime"), 2)*1000;
        self.rotationPartmanometr6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.manometr6#touchRotLimit"), 10));
    end;

-- voda

local rotationPartNodevoda1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda1#index"));
    if rotationPartNodevoda1 ~= nil then
        self.rotationPartvoda1 = {};
        self.rotationPartvoda1.node = rotationPartNodevoda1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda1#minRot"));
        self.rotationPartvoda1.minRot = {};
        self.rotationPartvoda1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda1#maxRot"));
        self.rotationPartvoda1.maxRot = {};
        self.rotationPartvoda1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda1#rotTime"), 2)*1000;
        self.rotationPartvoda1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda1#touchRotLimit"), 10));
    end;
local rotationPartNodevoda2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda2#index"));
    if rotationPartNodevoda2 ~= nil then
        self.rotationPartvoda2 = {};
        self.rotationPartvoda2.node = rotationPartNodevoda2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda2#minRot"));
        self.rotationPartvoda2.minRot = {};
        self.rotationPartvoda2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda2#maxRot"));
        self.rotationPartvoda2.maxRot = {};
        self.rotationPartvoda2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda2#rotTime"), 2)*1000;
        self.rotationPartvoda2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda2#touchRotLimit"), 10));
    end;
local rotationPartNodevoda3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda3#index"));
    if rotationPartNodevoda3 ~= nil then
        self.rotationPartvoda3 = {};
        self.rotationPartvoda3.node = rotationPartNodevoda3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda3#minRot"));
        self.rotationPartvoda3.minRot = {};
        self.rotationPartvoda3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda3#maxRot"));
        self.rotationPartvoda3.maxRot = {};
        self.rotationPartvoda3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda3#rotTime"), 2)*1000;
        self.rotationPartvoda3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda3#touchRotLimit"), 10));
    end;
local rotationPartNodevoda4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda4#index"));
    if rotationPartNodevoda4 ~= nil then
        self.rotationPartvoda4 = {};
        self.rotationPartvoda4.node = rotationPartNodevoda4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda4#minRot"));
        self.rotationPartvoda4.minRot = {};
        self.rotationPartvoda4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda4#maxRot"));
        self.rotationPartvoda4.maxRot = {};
        self.rotationPartvoda4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda4#rotTime"), 2)*1000;
        self.rotationPartvoda4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda4#touchRotLimit"), 10));
    end;

-- maslo

local rotationPartNodemaslo1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.maslo1#index"));
    if rotationPartNodemaslo1 ~= nil then
        self.rotationPartmaslo1 = {};
        self.rotationPartmaslo1.node = rotationPartNodemaslo1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.maslo1#minRot"));
        self.rotationPartmaslo1.minRot = {};
        self.rotationPartmaslo1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmaslo1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmaslo1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.maslo1#maxRot"));
        self.rotationPartmaslo1.maxRot = {};
        self.rotationPartmaslo1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmaslo1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmaslo1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmaslo1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.maslo1#rotTime"), 2)*1000;
        self.rotationPartmaslo1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.maslo1#touchRotLimit"), 10));
    end;
local rotationPartNodemaslo2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.maslo2#index"));
    if rotationPartNodemaslo2 ~= nil then
        self.rotationPartmaslo2 = {};
        self.rotationPartmaslo2.node = rotationPartNodemaslo2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.maslo2#minRot"));
        self.rotationPartmaslo2.minRot = {};
        self.rotationPartmaslo2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmaslo2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmaslo2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.maslo2#maxRot"));
        self.rotationPartmaslo2.maxRot = {};
        self.rotationPartmaslo2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmaslo2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmaslo2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmaslo2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.maslo2#rotTime"), 2)*1000;
        self.rotationPartmaslo2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.maslo2#touchRotLimit"), 10));
    end;
local rotationPartNodemaslo3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.maslo3#index"));
    if rotationPartNodemaslo3 ~= nil then
        self.rotationPartmaslo3 = {};
        self.rotationPartmaslo3.node = rotationPartNodemaslo3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.maslo3#minRot"));
        self.rotationPartmaslo3.minRot = {};
        self.rotationPartmaslo3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmaslo3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmaslo3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.maslo3#maxRot"));
        self.rotationPartmaslo3.maxRot = {};
        self.rotationPartmaslo3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmaslo3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmaslo3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmaslo3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.maslo3#rotTime"), 2)*1000;
        self.rotationPartmaslo3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.maslo3#touchRotLimit"), 10));
     end;

-- ampermetr

local rotationPartNodeamper1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper1#index"));
    if rotationPartNodeamper1 ~= nil then
        self.rotationPartamper1 = {};
        self.rotationPartamper1.node = rotationPartNodeamper1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper1#minRot"));
        self.rotationPartamper1.minRot = {};
        self.rotationPartamper1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper1#maxRot"));
        self.rotationPartamper1.maxRot = {};
        self.rotationPartamper1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper1#rotTime"), 2)*1000;
        self.rotationPartamper1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper1#touchRotLimit"), 10));
    end;
local rotationPartNodeamper2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper2#index"));
    if rotationPartNodeamper2 ~= nil then
        self.rotationPartamper2 = {};
        self.rotationPartamper2.node = rotationPartNodeamper2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper2#minRot"));
        self.rotationPartamper2.minRot = {};
        self.rotationPartamper2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper2#maxRot"));
        self.rotationPartamper2.maxRot = {};
        self.rotationPartamper2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper2#rotTime"), 2)*1000;
        self.rotationPartamper2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper2#touchRotLimit"), 10));
    end;
local rotationPartNodeamper3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper3#index"));
    if rotationPartNodeamper3 ~= nil then
        self.rotationPartamper3 = {};
        self.rotationPartamper3.node = rotationPartNodeamper3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper3#minRot"));
        self.rotationPartamper3.minRot = {};
        self.rotationPartamper3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper3#maxRot"));
        self.rotationPartamper3.maxRot = {};
        self.rotationPartamper3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper3#rotTime"), 2)*1000;
        self.rotationPartamper3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper3#touchRotLimit"), 10));
    end;
local rotationPartNodeamper4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper4#index"));
    if rotationPartNodeamper4 ~= nil then
        self.rotationPartamper4 = {};
        self.rotationPartamper4.node = rotationPartNodeamper4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper4#minRot"));
        self.rotationPartamper4.minRot = {};
        self.rotationPartamper4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper4#maxRot"));
        self.rotationPartamper4.maxRot = {};
        self.rotationPartamper4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper4#rotTime"), 2)*1000;
        self.rotationPartamper4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper4#touchRotLimit"), 10));
    end;
local rotationPartNodeamper5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper5#index"));
    if rotationPartNodeamper5 ~= nil then
        self.rotationPartamper5 = {};
        self.rotationPartamper5.node = rotationPartNodeamper5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper5#minRot"));
        self.rotationPartamper5.minRot = {};
        self.rotationPartamper5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper5#maxRot"));
        self.rotationPartamper5.maxRot = {};
        self.rotationPartamper5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper5#rotTime"), 2)*1000;
        self.rotationPartamper5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper5#touchRotLimit"), 10));
    end;
local rotationPartNodeamper6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.amper6#index"));
    if rotationPartNodeamper6 ~= nil then
        self.rotationPartamper6 = {};
        self.rotationPartamper6.node = rotationPartNodeamper6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper6#minRot"));
        self.rotationPartamper6.minRot = {};
        self.rotationPartamper6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.amper6#maxRot"));
        self.rotationPartamper6.maxRot = {};
        self.rotationPartamper6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartamper6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartamper6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartamper6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper6#rotTime"), 2)*1000;
        self.rotationPartamper6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.amper6#touchRotLimit"), 10));
    end;

-- kardan

	self.cShafts = {};	
	
	local i = -1;
	while true do
		i = i + 1;
		local index = getXMLString(xmlFile, string.format('vehicle.cardanShaft.shaft(%d)#index', i));
		if index == nil then break; end;
		local cs = {};
		cs.idx = Utils.indexToObject(self.components, index);
		cs.spd = getXMLFloat(xmlFile, string.format('vehicle.cardanShaft.shaft(%d)#speed', i));
		table.insert(self.cShafts, cs);
	end;
end;
      
function zil:delete() 
    for _, particle in pairs(self.drivingParticles) do
        Utils.deleteParticleSystem(particle.ps);
    end;   
end;

function zil:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function zil:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_KP_0 then
	self.help = not self.help;
    end;

-- Wipers

     if isDown and sym == Input.KEY_KP_divide then
		self.wiper1Active = not self.wiper1Active;
	  	self.wiper2Active = not self.wiper2Active;
	 end;
	if sym == Input.KEY_leftbracket then
		self.rotation1Max = isDown;
	end;
	if sym == Input.KEY_rightbracket then
		self.rotation1Min = isDown;
	end;
	if sym == Input.KEY_comma then
		self.rotation2Max = isDown;
	end;
	if sym == Input.KEY_period then
		self.rotation2Min = isDown;
	end;
end;

function zil:update(dt)
if self.isMotorStarted and self.fan ~= nil then
    rotate(self.fan, dt*0.007, 0, 0);
end;

--other to motor started

if self.isMotorStarted then
self.rotationMaxmanometr1 = true;
self.rotationMaxmanometr2 = false;
self.rotationMaxmanometr5 = true;
self.rotationMaxmanometr6 = false;
self.rotationMaxvoda1 = true;
self.rotationMaxvoda2 = false;
self.rotationMaxvoda3 = true;
self.rotationMaxvoda4 = false;
self.rotationMaxmaslo2 = true;
self.rotationMaxmaslo3 = false;
self.rotationMaxamper1 = true;
self.rotationMaxamper2 = true;
self.rotationMaxamper3 = true;
self.rotationMaxamper4 = false;
self.rotationMaxamper5 = false;
self.rotationMaxamper6 = false;
         else
self.rotationMaxmanometr2 = true;
self.rotationMaxmanometr1 = false;
self.rotationMaxmanometr6 = true;
self.rotationMaxmanometr5 = false;
self.rotationMaxvoda1 = false;
self.rotationMaxvoda2 = true;
self.rotationMaxvoda3 = false;
self.rotationMaxvoda4 = true;
self.rotationMaxmaslo3 = true;
self.rotationMaxmaslo2 = false;
self.rotationMaxamper1 = false;
self.rotationMaxamper2 = false;
self.rotationMaxamper3 = false;
self.rotationMaxamper4 = true;
self.rotationMaxamper5 = true;
self.rotationMaxamper6 = true;
              end;

-- manometr break

if self.brakeLightsVisibility then
self.rotationMaxmanometr = true;
self.rotationMaxmanometr0 = false;
self.rotationMaxmanometr3 = true;
self.rotationMaxmanometr4 = false;
         else
self.rotationMaxmanometr0 = true;
self.rotationMaxmanometr = false;
self.rotationMaxmanometr4 = true;
self.rotationMaxmanometr3 = false;
	end;

if self.rotationMaxmanometr == true then
if self.rotationPartmanometr ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr.maxRot, self.rotationPartmanometr.minRot, 3, self.rotationPartmanometr.rotTime, dt, not self.rotationMaxmanometr);
		   setRotation(self.rotationPartmanometr.node, unpack(newRot));
       end;
    end;

if self.rotationMaxmanometr0 == true then
if self.rotationPartmanometr0 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr0.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr0.maxRot, self.rotationPartmanometr0.minRot, 3, self.rotationPartmanometr0.rotTime, dt, not self.rotationMaxmanometr0);
		   setRotation(self.rotationPartmanometr0.node, unpack(newRot));
       end;
   end;
if self.rotationMaxmanometr1 == true then
if self.rotationPartmanometr1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr1.maxRot, self.rotationPartmanometr1.minRot, 3, self.rotationPartmanometr1.rotTime, dt, not self.rotationMaxmanometr1);
		   setRotation(self.rotationPartmanometr1.node, unpack(newRot));
       end;
   end;
if self.rotationMaxmanometr2 == true then
if self.rotationPartmanometr2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr2.maxRot, self.rotationPartmanometr2.minRot, 3, self.rotationPartmanometr2.rotTime, dt, not self.rotationMaxmanometr2);
		   setRotation(self.rotationPartmanometr2.node, unpack(newRot));
       end;
   end;
if self.rotationMaxmanometr3 == true then
if self.rotationPartmanometr3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr3.maxRot, self.rotationPartmanometr3.minRot, 3, self.rotationPartmanometr3.rotTime, dt, not self.rotationMaxmanometr3);
		   setRotation(self.rotationPartmanometr3.node, unpack(newRot));
       end;
   end;
if self.rotationMaxmanometr4 == true then
if self.rotationPartmanometr4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr4.maxRot, self.rotationPartmanometr4.minRot, 3, self.rotationPartmanometr4.rotTime, dt, not self.rotationMaxmanometr4);
		   setRotation(self.rotationPartmanometr4.node, unpack(newRot));
       end;
   end;
if self.rotationMaxmanometr5 == true then
if self.rotationPartmanometr5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr5.maxRot, self.rotationPartmanometr5.minRot, 3, self.rotationPartmanometr5.rotTime, dt, not self.rotationMaxmanometr5);
		   setRotation(self.rotationPartmanometr5.node, unpack(newRot));
       end;
   end;
if self.rotationMaxmanometr6 == true then
if self.rotationPartmanometr6 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmanometr6.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmanometr6.maxRot, self.rotationPartmanometr6.minRot, 3, self.rotationPartmanometr6.rotTime, dt, not self.rotationMaxmanometr6);
		   setRotation(self.rotationPartmanometr6.node, unpack(newRot));
       end;
   end;

-- voda

if self.rotationMaxvoda1 == true then
if self.rotationPartvoda1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda1.maxRot, self.rotationPartvoda1.minRot, 3, self.rotationPartvoda1.rotTime, dt, not self.rotationMaxvoda1);
		   setRotation(self.rotationPartvoda1.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda2 == true then
if self.rotationPartvoda2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda2.maxRot, self.rotationPartvoda2.minRot, 3, self.rotationPartvoda2.rotTime, dt, not self.rotationMaxvoda2);
		   setRotation(self.rotationPartvoda2.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda3 == true then
if self.rotationPartvoda3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda3.maxRot, self.rotationPartvoda3.minRot, 3, self.rotationPartvoda3.rotTime, dt, not self.rotationMaxvoda3);
		   setRotation(self.rotationPartvoda3.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda4 == true then
if self.rotationPartvoda4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda4.maxRot, self.rotationPartvoda4.minRot, 3, self.rotationPartvoda4.rotTime, dt, not self.rotationMaxvoda4);
		   setRotation(self.rotationPartvoda4.node, unpack(newRot));
       end;
   end;

-- maslo

local maxmaslo = 2000;
	if self.rotationPartmaslo1 ~= nil then
		local x, y, z = getRotation(self.rotationPartmaslo1.node);
		y = ((self.rotationPartmaslo1.maxRot[2] - self.rotationPartmaslo1.minRot[2]) / maxmaslo) * self.motor.lastMotorRpm + self.rotationPartmaslo1.minRot[2];
		setRotation(self.rotationPartmaslo1.node, x, y ,z);
	end;

if self.rotationMaxmaslo2 == true then
if self.rotationPartmaslo2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmaslo2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmaslo2.maxRot, self.rotationPartmaslo2.minRot, 3, self.rotationPartmaslo2.rotTime, dt, not self.rotationMaxmaslo2);
		   setRotation(self.rotationPartmaslo2.node, unpack(newRot));
       end;
   end;
if self.rotationMaxmaslo3 == true then
if self.rotationPartmaslo3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartmaslo3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmaslo3.maxRot, self.rotationPartmaslo3.minRot, 3, self.rotationPartmaslo3.rotTime, dt, not self.rotationMaxmaslo3);
		   setRotation(self.rotationPartmaslo3.node, unpack(newRot));
       end;
   end;

-- ampermetr

if self.rotationMaxamper1 == true then
if self.rotationPartamper1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper1.maxRot, self.rotationPartamper1.minRot, 3, self.rotationPartamper1.rotTime, dt, not self.rotationMaxamper1);
		   setRotation(self.rotationPartamper1.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper2 == true then
if self.rotationPartamper2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper2.maxRot, self.rotationPartamper2.minRot, 3, self.rotationPartamper2.rotTime, dt, not self.rotationMaxamper2);
		   setRotation(self.rotationPartamper2.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper3 == true then
if self.rotationPartamper3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper3.maxRot, self.rotationPartamper3.minRot, 3, self.rotationPartamper3.rotTime, dt, not self.rotationMaxamper3);
		   setRotation(self.rotationPartamper3.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper4 == true then
if self.rotationPartamper4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper4.maxRot, self.rotationPartamper4.minRot, 3, self.rotationPartamper4.rotTime, dt, not self.rotationMaxamper4);
		   setRotation(self.rotationPartamper4.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper5 == true then
if self.rotationPartamper5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper5.maxRot, self.rotationPartamper5.minRot, 3, self.rotationPartamper5.rotTime, dt, not self.rotationMaxamper5);
		   setRotation(self.rotationPartamper5.node, unpack(newRot));
       end;
   end;
if self.rotationMaxamper6 == true then
if self.rotationPartamper6 ~= nil then
		   local x, y, z = getRotation(self.rotationPartamper6.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartamper6.maxRot, self.rotationPartamper6.minRot, 3, self.rotationPartamper6.rotTime, dt, not self.rotationMaxamper6);
		   setRotation(self.rotationPartamper6.node, unpack(newRot));
       end;
   end;

local maxKmh = 70;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;
	if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;

local maxtahometr = 2000;
	if self.rotationParttahometr ~= nil then
		local x, y, z = getRotation(self.rotationParttahometr.node);
		y = ((self.rotationParttahometr.maxRot[2] - self.rotationParttahometr.minRot[2]) / maxtahometr) * self.motor.lastMotorRpm + self.rotationParttahometr.minRot[2];
		setRotation(self.rotationParttahometr.node, x, y ,z);
	end;

-- Wiper

        if self.wiper1Active then
		if self.delayWischer1 >= 0 then
			self.delayWischer1 = self.delayWischer1 -dt;
		end;
		if self.delayWischer2 >= 0 then
			self.delayWischer2 = self.delayWischer2 -dt;
		end;
		if not self.wiper1Max then
		   if self.delayWischer1 < 0 then
				self.delayWischer2 = 1000;
				self.wiper1Max = true;
				self.wiper2Max = true;
			end;
		end;
		if self.wiper1Max then
			if self.delayWischer2 < 0 then
				self.delayWischer1 = 1000;
				self.wiper1Max = false;
				self.wiper2Max = false;
			end;
		end;
	else
		self.wiper1Max = false;
		self.wiper2Max = false;
	end;

    if self.wiper1 ~= nil then
       	local x, y, z = getRotation(self.wiper1.node);
       	local rot = {x,y,z};
       	local newRot = Utils.getMovedLimitedValues(rot, self.wiper1.maxRot, self.wiper1.minRot, 3, self.wiper1.rotTime, dt, not self.wiper1Max);
       	setRotation(self.wiper1.node, unpack(newRot));
    end;
		
	if self.wiper2 ~= nil then
       	local x, y, z = getRotation(self.wiper2.node);
       	local rot = {x,y,z};
       	local newRot = Utils.getMovedLimitedValues(rot, self.wiper2.maxRot, self.wiper2.minRot, 3, self.wiper2.rotTime, dt, not self.wiper2Max);
       	setRotation(self.wiper2.node, unpack(newRot));
    end;

	local doRotate = self.rotation1Max or self.rotation1Min 
	if self.rotation1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	local doRotate = self.rotation2Max or self.rotation2Min 
	if self.rotation2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
end;

function zil:draw()
if not self.help then
	setTextColor(1,1,1,1);
            renderText(0.76, 0.167, 0.0193, g_i18n:getText("InfoOn"));
        else
		  renderText();
        end;
        
    if self.help then
		renderText(0.76, 0.167, 0.0193, g_i18n:getText("InfoOff"));
		renderText(0.76, 0.60, 0.025, g_i18n:getText("Info_avto"));
        renderText(0.76, 0.58, 0.02, g_i18n:getText("Signal"));
        renderText(0.76, 0.56, 0.02, g_i18n:getText("Svet"));
        renderText(0.76, 0.54, 0.02, g_i18n:getText("Lev_povorot"));
		renderText(0.76, 0.50, 0.02, g_i18n:getText("Prav_povorot"));
		renderText(0.76, 0.52, 0.02, g_i18n:getText("Avariyka"));
		renderText(0.76, 0.48, 0.02, g_i18n:getText("Lev_dver"));
		renderText(0.76, 0.46, 0.02, g_i18n:getText("Prav_dver"));
		renderText(0.76, 0.44, 0.02, g_i18n:getText("Kapot"));
		renderText(0.76, 0.42, 0.02, g_i18n:getText("wiper"));
		renderText(0.76, 0.40, 0.02, g_i18n:getText("Zerkala"));
	end;

end;

function zil:updateTick(dt)	

	if self.isClient then	
		if self:getIsActive() then
			local isVisible = false;
			local camera = getCamera();
			if camera ~= 0 then
				local x,y,z = getWorldTranslation(camera);
				local x1,y1,z1 = getWorldTranslation(self.rootNode);
				local distance = Utils.vector3Length(x-x1,y-y1,z-z1);
				isVisible = (distance < 300);
			end;
			
            for k, particle in pairs(self.drivingParticles) do		
				local isActive = false;
				
				if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
					if particle.wheel ~= nil then
						local x,y,z = getWorldTranslation(self.wheels[particle.wheel].repr);--getWheelShapeContactPoint(self.wheels[particle.wheel].node, self.wheels[particle.wheel].wheelShape);
						y = y - self.wheels[particle.wheel].radius;
						
						if y ~= nil then
							local height = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x,y,z); 
							local hasGroundContact = math.abs(y - height) < self.drivingParticleThreshold;
							
							if self.lastSpeedReal > particle.minSpeed and (particle.direction == 0 or (particle.direction > 0) == (self.movingDirection > 0)) and hasGroundContact then								
								isActive = isVisible;
							end;
						end;
					end;
				end;
				Utils.setEmittingState(particle.ps, isActive);
            end;
		else
			for _, particle in pairs(self.drivingParticles) do
				Utils.setEmittingState(particle.ps, false);
			end;
        end;
    end;

-- kardan

	local x,y,z = getRotation(self.wheels[1].driveNode);
	for i,shaft in pairs(self.cShafts) do
		setRotation(shaft.idx, 0,0, x*shaft.spd);			
	end;
end;

function zil:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
