BuyableForestLoader = {};
BuyableForestLoader.forests = {};
g_BaseDir = g_currentModDirectory;
BuyableForestLoader.MAXTREESPERFILE = 5000;
BuyableForestLoader.DEFAULTpricePerTreeInitial = 250;
BuyableForestLoader.DEFAULTpricePerTreeDaily = 1.5;


function BuyableForestLoaderOnCreate(self,id)
	print("created Buyable Forest, id: ", tostring(id));

	local forest = BuyableForest:new(g_server ~= nil, g_client ~= nil);
    g_currentMission:addOnCreateLoadedObject(forest);
    forest:load(id);
    forest:register(true);
    table.insert(BuyableForestLoader.forests, forest);
	
end;
function BuyableForestLoader:loadMap(name)
	BuyableForestLoader.nearestForest = nil;	
	
end;
function BuyableForestLoader:deleteMap()
	BuyableForestLoader.forests = {};
	
end;
function BuyableForestLoader:mouseEvent(posX, posY, isDown, isUp, button)
end;
function BuyableForestLoader:keyEvent(unicode, sym, modifier, isDown)
end;


function BuyableForestLoader:update(dt)
	if g_currentMission:getIsClient() then
		if g_gui.currentGui == nil then
			if g_currentMission.controlPlayer and g_currentMission.player ~= nil then	
				if g_currentMission.controlledVehicle == nil then
					local px,_,pz = getWorldTranslation(g_currentMission.player.rootNode);
					local nearestDistance = 1e10;
					if BuyableForestLoader.nearestForest~= nil then
						if BuyableForestLoader.nearestForest.isBought or BuyableForestLoader.nearestForest.isConverting then
							BuyableForestLoader.nearestForest = nil;
						end;
					end;

					if table.getn(BuyableForestLoader.forests) > 0 then
						for index,forest in pairs(BuyableForestLoader.forests) do
							if not (forest.isBought or forest.isConverting) then
								local distance2 = (px-forest.centerX)^2 + (pz-forest.centerZ)^2;
								if distance2 < nearestDistance then
									nearestDistance = distance2;
									BuyableForestLoader.nearestForest = forest;
								end;
							end;							
						end;			
					end;

				end;
			end;
		end;
	end;
end;



function BuyableForestLoader:draw(dt)
	for i,forest in ipairs(BuyableForestLoader.forests) do
		forest:draw(forest);
	end;	
end;

function BuyableForestLoader:getNumberOfTrees()
	
	
	local fields = {"growingTrees", "clientTrees", "splitTrees"};
	local trees = 0;
	for _,field in pairs(fields) do
		trees = trees + table.getn(g_currentMission.plantedTrees[field]);
	end;
	return trees
end;



addModEventListener(BuyableForestLoader);



BuyableForest = {};

local BuyableForest_mt = Class(BuyableForest,Object);

function BuyableForest:new(isServer, isClient)
	local self = Object:new(isServer, isClient, BuyableForest_mt)
	return self
 end;
 
function BuyableForest:load(id)
	self.nodeId = id;
	
	local pricePerTreeInitial = getUserAttribute(self.nodeId,"pricePerTree_initial");
	local pricePerTreeDaily = getUserAttribute(self.nodeId,"pricePerTree_daily");
	
	if pricePerTreeInitial ~= nil then
		self.pricePerTreeInitial = pricePerTreeInitial;
		BuyableForestLoader.pricePerTreeInitial = pricePerTreeInitial;
	else
		self.pricePerTreeInitial = Utils.getNoNil(BuyableForestLoader.pricePerTreeInitial,BuyableForestLoader.DEFAULTpricePerTreeInitial);
	end;
	
	if pricePerTreeDaily ~= nil then
		self.pricePerTreeDaily = pricePerTreeDaily;
		BuyableForestLoader.pricePerTreeDaily = pricePerTreeDaily;
	else
		self.pricePerTreeDaily = Utils.getNoNil(BuyableForestLoader.pricePerTreeDaily,BuyableForestLoader.DEFAULTpricePerTreeDaily);
	end;
	
	local N = getNumOfChildren(id);
	print("found "..tostring(N).." trees")
	self.trees2D = {};
	local x = 0;
	local z = 0;
	for k = 1,N,1 do
		self.trees2D[k] = getChildAt(id,k-1);		
		local tx,_,tz = getWorldTranslation(self.trees2D[k]);
		x = x + tx;
		z = z + tz;
	end;
	
	self.price = self.pricePerTreeInitial*N;
	self.priceDaily = self.pricePerTreeDaily*N;
	
	
	self.centerX = x/N;
	self.centerZ = z/N;
	
	
	self.isBought = false;
	self.isConverting = false;
	self.conversionIndex = 1;

	g_currentMission:addNodeObject(self.nodeId, self)
	g_currentMission:addOnCreateLoadedObjectToSave(self)
	if self.pricePerTreeDaily > 0 then
		g_currentMission.environment:addDayChangeListener(self)
	end;

end; 

function BuyableForest:delete()
end;

function BuyableForest:dayChanged()
	if self.isServer and (self.isBought or self.isConverting) then
		local money = self.priceDaily;

		g_currentMission:addSharedMoney(-money, "other")
	end;
end;

function BuyableForest:readStream(streamId, connection)
	BuyableForest:superClass().readStream(self, streamId, connection)
	self.isBought = streamReadBool(streamId);
	self.isConverting = streamReadBool(streamId);
	if self.isBought then
		setVisibility(self.nodeId,false);
    end;
end;

function BuyableForest:writeStream(streamId, connection)
   BuyableForest:superClass().readStream(self, streamId, connection)
   streamWriteBool(streamId, self.isBought);
   streamWriteBool(streamId, self.isConverting);
  
end;

function BuyableForest:readUpdateStream(streamId, timestamp, connection)
	BuyableForest:superClass().readUpdateStream(self, streamId, timestamp, connection)	
end;

function BuyableForest:writeUpdateStream(streamId, connection, dirtyMask)
	BuyableForest:superClass().writeUpdateStream(self, streamId, connection, dirtyMask)	
end;

function BuyableForest:loadFromAttributesAndNodes(xmlFile, key)
	self.isBought = Utils.getNoNil(getXMLBool(xmlFile, key.."#isBought"),false);
	
	if self.isBought then
		setVisibility(self.nodeId,false)
	end;
	
	return true
end

function BuyableForest:getSaveAttributesAndNodes(nodeIdent)
	local attributes = " isBought=\"" .. tostring(self.isBought or self.isConverting) .. "\""	
	return attributes, nodes
end



function BuyableForest:buyDialogueCallback(setActive)
	self.doBuy = setActive;	
	g_gui:showGui('');
end;


function BuyableForest.buy(self,cost)	
	if self.isServer then		
		g_currentMission:addSharedMoney(-cost, "other")
	end;

	if g_server ~= nil then
		g_server:broadcastEvent(ForestBuyEvent:new(self), nil, nil, self);
	else
		g_client:getServerConnection():sendEvent(ForestBuyEvent:new(self));
	end

	self.isConverting = true;	
end;


function BuyableForest:update(dt)
	if self.doBuy then
		local money = self.price;
		BuyableForest.buy(self,money)
		self.doBuy = false;
	end;
		
	if self:getShowInfo() and (self.isServer or g_currentMission.isMasterUser) and not self.isBought then
		local money = self.price
			if InputBinding.isPressed(InputBinding.buyableForest_mod) then
				if g_currentMission.missionStats.money >= money then	
					if InputBinding.hasEvent(InputBinding.buyableForest_buy) then

						local daily = self.priceDaily;
						local yesNoDialogue = g_gui:showGui('YesNoDialog');
						yesNoDialogue.target.titleElement:setText(g_i18n:getText("openBuyableForest"));

						local txt = string.format(g_i18n:getText("buyDialog1").."\n"..g_i18n:getText("buyDialog2").." "..g_i18n:formatMoney(g_i18n:getCurrency(money), 2).." \n "..g_i18n:getText("buyTreesDaily").." "..g_i18n:formatMoney(g_i18n:getCurrency(daily), 2)..g_i18n:getText("costsPerDay"), table.getn(self.trees2D))
						
						yesNoDialogue.target:setText(txt);
						yesNoDialogue.target:setCallbacks(self.buyDialogueCallback, self);					
					end;
					g_currentMission:addHelpButtonText(g_i18n:getText("buyForest"), InputBinding.buyableForest_buy);
				end;
				local NtreesInNearest = table.getn(self.trees2D);					
				g_currentMission:addExtraPrintText(g_i18n:getText("NrTrees").." "..tostring(NtreesInNearest).." "..g_i18n:getText("trees"))
				g_currentMission:addExtraPrintText(g_i18n:getText("buyTreesInitial").." "..g_i18n:formatMoney(g_i18n:getCurrency(self.price), 2))
				g_currentMission:addExtraPrintText(g_i18n:getText("buyTreesDaily").." "..g_i18n:formatMoney(g_i18n:getCurrency(self.priceDaily), 2)..g_i18n:getText("costsPerDay"))				
				g_currentMission:addExtraPrintText(g_i18n:getText("NrTreesTotal").." "..tostring(BuyableForestLoader:getNumberOfTrees()).." "..g_i18n:getText("trees"))
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("openBuyableForest"), InputBinding.buyableForest_mod);
			end;
		-- end;
	end;

	if true or self.isServer then
		if self.isConverting then
			local tree = self.trees2D[self.conversionIndex];
			if tree ~= nil then
				setVisibility(tree, false);
				if self.isServer then
					local growthOffset = 0.7;
					local _,scale,_ = getScale(tree);
					local rx,ry,rz = getRotation(tree);
					local variTerm = 2*(scale-1);
					
					local growth = growthOffset + (1-growthOffset)*variTerm*1.2;
					
					local px,py,pz = getWorldTranslation(tree);
					py = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, px,py,pz)
					TreePlantUtil.plantTree(g_currentMission.plantedTrees,TreePlantUtil.TREETYPE_TREEFIR,px,py,pz,rx,ry,rz,growth);
				end;
			end;
			self.conversionIndex = self.conversionIndex + 1;
			if self.conversionIndex > table.getn(self.trees2D) then
				self.isConverting = false;
				self.isBought = true;
			end;
		end;
	end;
end;

function BuyableForest:updateTick(dt)
	
end;


function BuyableForest:getShowInfo()
	return BuyableForestLoader.nearestForest == self;
	
end;

-- g_onCreateUtil.addOnCreateFunction("BuyableForestOnCreate", BuyableForestLoader.onCreate);


------END of working script---------
if true then --alternative tree save system

	function TreePlantUtil.getTreeSaveAttributesAndNodes()
		-- print("they may torture me... but I wont tell them nothing!")
		return ""
	end;
	

	local oldSave = TreePlantUtil.getSaveAttributesAndNodes;
	function TreePlantUtil.getSaveAttributesAndNodes(self,nodes,arg3) --no idea what arg3 is. doesnt matter
	
		oldSave(self,nodes,arg3)

		BuyableForestLoader.saveTreesSplitXmlAfterByField(self,"growingTrees");
		BuyableForestLoader.saveTreesSplitXmlAfterByField(self,"clientTrees");
		BuyableForestLoader.saveTreesSplitXmlAfterByField(self,"splitTrees");
		
		return "",""
	end;
	
	
	local oldLoadAttributes = TreePlantUtil.loadFromAttributesAndNodes;
	function TreePlantUtil.loadFromAttributesAndNodes(treesData,xmlFile,baseKey)
	
		local saveDir = g_currentMission.missionInfo.savegameDirectory;	
	
		local fields = {"growingTrees", "clientTrees", "splitTrees"};
		for _,field in pairs(fields) do
			local fileIndex = 1;			
			while saveDir~= nil do
				local fileName = saveDir.."/BuyableTrees_"..field.."_"..tostring(fileIndex)..".xml";
				if fileExists(fileName) then
					print("loading trees from "..fileName)
					fileIndex = fileIndex + 1;
					local Xml = loadXMLFile("VehiclesXML", fileName, "careerVehicles"); --load file					
					oldLoadAttributes(treesData,Xml,baseKey)
					delete(Xml)
				else
					break;
				end;
			end;
						
		end;
	end;
end;	


function BuyableForestLoader.saveTreesSplitXmlAfterByField(self,field)
	local N = table.getn(g_currentMission.plantedTrees[field]);
	local saveDir = g_currentMission.missionInfo.savegameDirectory;	
	
	if N > 0 then
		local startIndex = 1;
		local fileIndex = 1;
		while true do
			local endIndex = math.min(startIndex+BuyableForestLoader.MAXTREESPERFILE-1,N);
			
			local fileName = saveDir.."/BuyableTrees_"..field.."_"..tostring(fileIndex)..".xml";
			print("saving trees to "..fileName)
			local Xml = io.open(fileName, "w")
			if Xml ~= nil then
Xml:write([[
<?xml version="1.0" encoding="utf-8" standalone="no" ?>
    <careerVehicles>
        <plantedTrees>
]])			
				local kk = 1;
				
				for k = startIndex,endIndex,1 do
					local tree = g_currentMission.plantedTrees[field][k];
										
					local str = '            <tree treeType="%s" position="%.4f %.4f %.4f" rotation="%.4f %.4f %.4f" growthState="%.4f" growthStateI="%d" isGrowing="%s" splitShapeFileId="%d"/>';

					local growthStateI = tree.growthStateI;
					if growthStateI == nil then
						if tree.growthState > 0.999 then
							growthStateI = 5;
						else
							growthStateI = math.floor(tree.growthState*4)+1;							
						end;
					end;
					
					local treeType = TreePlantUtil.treeTypeIndexToDesc[tree.treeType].name
					local strSave = string.format(str,treeType,tree.x,tree.y,tree.z,tree.rx,tree.ry,tree.rz,tree.growthState,growthStateI,tostring(Utils.getNoNil(tree.isGrowing,tree.growthState<1.0)),tree.splitShapeFileId);
					Xml:write(strSave.."\n")
					
					kk = kk+1;
				end;

				Xml:write("        </plantedTrees>\n")
				Xml:write("    </careerVehicles>")
				Xml:close()
			end;
			startIndex = endIndex+1;
			fileIndex = fileIndex+1;
			if endIndex == N then
				break;
			end;
		end;
	end;	
end;












ForestBuyEvent = {};
ForestBuyEvent_mt = Class(ForestBuyEvent, Event);

InitEventClass(ForestBuyEvent, "ForestBuyEvent");

function ForestBuyEvent:emptyNew()
    local self = Event:new(ForestBuyEvent_mt);
    return self;
end;

function ForestBuyEvent:new(forest)
    local self = ForestBuyEvent:emptyNew()
    self.forest = forest;
    return self;
end;

function ForestBuyEvent:readStream(streamId, connection)
	self.forest = networkGetObject(streamReadInt32(streamId));
    self:run(connection);
end;

function ForestBuyEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.forest));
end;

function ForestBuyEvent:run(connection)
    if not connection:getIsServer() then
		g_server:broadcastEvent(ForestBuyEvent:new(self.forest), nil, nil, self.forest);
		self.forest.isConverting = true;
    else
		self.forest.isConverting = true;		
	end;
end;