----
-- upsidedown 3.11.2014

Inching = {};
-- local Inching_directory = g_currentModDirectory;

-- source(Utils.getFilename("Inching_Event.lua", Inching_directory));
-- source(Utils.getFilename("Inching_SaveEvent.lua", Inching_directory));



function Inching:prerequisitesPresent(specializations)
    return true;
	--return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Inching:load(xmlFile)
	self.Inching = {};
	self.Inching.InchingLevel = 1;
	self.Inching.acceptsCruiseSpeed = true;
	self.Inching.cruiseSpeed = self.cruiseControl.maxSpeed; 
end;





function Inching:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Inching:keyEvent(unicode, sym, modifier, isDown)
end;


function Inching:updateTick(dt)
	if self.isEntered and self.isClient then
		if self.steeringEnabled then
			
			if self.Inching.InchingLevel < 0.999 then
				if self.Inching.acceptsCruiseSpeed then
					self.Inching.cruiseSpeed = self.cruiseControl.speed;
					
					self.Inching.acceptsCruiseSpeed = false;
				end;
				local newSpeed = self.Inching.InchingLevel*self.Inching.cruiseSpeed;
				if self.cruiseControl.speedSent ~= newSpeed then
					self:setCruiseControlMaxSpeed(newSpeed);
				end;				
				
			else
				self.Inching.acceptsCruiseSpeed = true; 
			end;			
			
		end;
	end;	

end;

function Inching:update(dt)
	if self.isEntered and self.isClient then
		if self.steeringEnabled then
			
			local axis = 0;
			local isAnalog = false;
			local inchingMin = 0.4;
			
			axis = InputBinding.getDigitalInputAxis(InputBinding.Inching);
			if InputBinding.isAxisZero(axis) then
				axis = InputBinding.getAnalogInputAxis(InputBinding.Inching)
				if not InputBinding.isAxisZero(axis) then
					isAnalog = true;
				
					if axis > 0 then
						inchingMin = 0;
					end;
					self.Inching.InchingLevel = 1-math.abs(axis);
				end
			else
				isAnalog = false;
			end;
			
			if not isAnalog then
				if axis ~= 0 then
					self.Inching.InchingLevel = self.Inching.InchingLevel - dt*0.003;
				elseif self.Inching.InchingLevel < 1 then
					self.Inching.InchingLevel = self.Inching.InchingLevel + 0.7*dt*0.001;				
				end
				
			end;			
			
			self.Inching.InchingLevel = Utils.clamp(self.Inching.InchingLevel,inchingMin,1);
						
		end
	end
	
end;


 -- function Inching:readUpdateStream(streamId, timestamp, connection)
    -- if connection:getIsServer() then       
		-- if streamReadBool(streamId) then
			-- self.Inching.InchingLevel = streamReadFloat32(streamId);
			-- self.motor.transmissionEfficiency = self.Inching.InchingLevel;
		-- end;
	-- end;
-- end;

-- function Inching:writeUpdateStream(streamId, connection, dirtyMask)
    -- if not connection:getIsServer() then
    	-- if streamWriteBool(streamId, bitAND(dirtyMask, self.steerableGroundFlag) ~= 0) then
			-- streamWriteFloat32(streamId, self.Inching.InchingLevel);
		-- end;
	-- end;
-- end;



function Inching:draw()
	
	
	
end;


function Inching:getSaveAttributesAndNodes(nodeIdent)
	local attributes = "";
	
	
	return attributes
end;


function Inching:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		
	
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end

function Inching:delete()	
end
