 local metadata = {
"## Interface:FS15 1.1.0.0 RC12",
"## Title: MapSiloBand",
"## Notes: Map Silo Frderband",
"## Author: Marhu",
"## Version: 2.6.0",
"## Date: 17.11.2014",
"## Web: http://marhu.net"
}
  
MapSiloBand = {};

local MapSiloBand_mt = Class(MapSiloBand);

function MapSiloBand.onCreate(id)
	g_currentMission:addUpdateable(MapSiloBand:new(id));
	--print("created MapSiloBand, id: ", id);
end;

function MapSiloBand:new(id, customMt)
  
	local instance = {};
	if customMt ~= nil then
		setmetatable(instance, customMt);
	else
		setmetatable(instance, MapSiloBand_mt);
	end;

	instance.ErrorTxt = "Error MapSiloBand: ("..getName(id)..") "
	
	local fruitType = getUserAttribute(id, "fruitType");
    if fruitType ~= nil then
		
		local trigger = SiloTrigger:new(g_server ~= nil, g_client ~= nil);
		local index = g_currentMission:addOnCreateLoadedObject(trigger);
		trigger:load(id);
		trigger:register(true);
		
		local findFillType = false;
		local desc = FruitUtil.fruitTypes[fruitType];
        if desc ~= nil then
			instance.Band = trigger;
			findFillType = true;
		elseif Fillable.fillTypeNameToInt[fruitType] then
			trigger.fillType = Fillable.fillTypeNameToInt[fruitType]
			instance.Band  = trigger;
			findFillType = true;
		end
		
		if findFillType == true then
			instance.isCowManure = Utils.getNoNil(getUserAttribute(id, "CowManure"), false);
			instance.isPigManure = Utils.getNoNil(getUserAttribute(id, "PigManure"), false);
			instance.isSameStrawGrass = Utils.getNoNil(getUserAttribute(id, "sameStrawGrass"), false);
			if instance.isCowManure or instance.isPigManure then
				if instance.isCowManure and instance.isPigManure then
					print(instance.ErrorTxt.."CowManure and PigManure selected (only one)");
				elseif trigger.fillType ~= Fillable.FILLTYPE_MANURE then
					if instance.isCowManure then
						print(instance.ErrorTxt.."CowManure selected but fruitType not Manure");
					else
						print(instance.ErrorTxt.."PigManure selected but fruitType not Manure");
					end;
				else
					instance.Ori_update = instance.Band.update;
					function instance.Band:update(dt) end;
					instance.PigStation = getUserAttribute(id, "PigStation")
					instance.PigStationAnimal = getUserAttribute(id, "PigStationAnimal")
				end;
			elseif instance.isSameStrawGrass then
				if trigger.fillType == Fillable.FILLTYPE_BARLEY_WINDROW or trigger.fillType == Fillable.FILLTYPE_WHEAT_WINDROW then
					instance.Stroh = true;
				elseif trigger.fillType == Fillable.FILLTYPE_GRASS_WINDROW or trigger.fillType == Fillable.FILLTYPE_DRYGRASS_WINDROW then
					instance.Gras = true;
				else
					print(instance.ErrorTxt.."SameStrawGrass invalid for ",fruitType);
					instance.isSameStrawGrass = nil;
				end
			end;
		else
			print(instance.ErrorTxt.."fruitType is not correct - ",fruitType);
		end;
				
		instance.plane = Utils.indexToObject(id, getUserAttribute(id, "PlaneIndex"));
        if instance.plane ~= nil then
            instance.planeShaderParameterName =  "uvScrollSpeed";
            local planeScrollSpeed = getUserAttribute(instance.plane, "scrollSpeed");
            if planeScrollSpeed ~= nil then
                instance.planeSpeedX, instance.planeSpeedY = Utils.getVectorFromString(planeScrollSpeed);
            end
            if instance.planeSpeedX == nil then
                instance.planeSpeedX = 0;
            end
            if instance.planeSpeedY == nil then
                instance.planeSpeedY = -0.75;
            end
			setVisibility(instance.plane, false);
            setShaderParameter(instance.plane, instance.planeShaderParameterName, 0, 0, 0, 0, false);
			self.PlaneTime = getUserAttribute(id, "PlaneTime")
			if self.PlaneTime then
				self.PlaneTime = self.PlaneTime * 60000;
			end
        end
	else
		print(instance.ErrorTxt.."fruitType = nil");
	end;
   
    return instance;
end;
  
function MapSiloBand:delete()
end;
  
function MapSiloBand:update(dt)
  
	if g_currentMission:getIsClient() then
		if self.Band.isFilling then
			if self.plane and not self.setShader then
				self.setShader = true
				setVisibility(self.plane, true);
				setShaderParameter(self.plane, self.planeShaderParameterName, self.planeSpeedX, self.planeSpeedY, 0, 0, false);
			end
			if self.PlaneTime then
				self.PlaneVisible = self.PlaneTime;
			end
		elseif self.plane then
			if self.setShader then
				self.setShader = nil
				setShaderParameter(self.plane, self.planeShaderParameterName, 0, 0, 0, 0, false);
				if not self.PlaneVisible then
					setVisibility(self.plane, false);
				end
			end
			if self.PlaneVisible then
				self.PlaneVisible = self.PlaneVisible - (dt * g_currentMission.missionStats.timeScale);
				if self.PlaneVisible <= 0 then
					setVisibility(self.plane, false);
					self.PlaneVisible = nil;
				end
			end
		end
	end
	
	if self.isPigManure and not self.PigManure then
		for k,v in pairs(g_currentMission.onCreateLoadedObjects) do
			if v.animalHusbandry and v.animalHusbandry.SchweineZuchtDirtyFlag then
				if v.animalHusbandry.manureHeap then
					if self.PigStation and self.PigStation ~= "" then
						if v.animalHusbandry.stationName and v.animalHusbandry.stationName == self.PigStation then
							self.PigManure = g_currentMission.onCreateLoadedObjects[k].animalHusbandry;
							break;	
						elseif v.animalHusbandry.StationNr and v.animalHusbandry.animal then
							if v.animalHusbandry.StationNr == tonumber(self.PigStation) and v.animalHusbandry.animal == self.PigStationAnimal then
								self.PigManure = g_currentMission.onCreateLoadedObjects[k].animalHusbandry;
								--print(string.format("find: %s - %d",v.animalHusbandry.animal or "not Animal",v.animalHusbandry.StationNr or "not Nr."))
								break;
							end;
						end;
					else
						self.PigManure = g_currentMission.onCreateLoadedObjects[k].animalHusbandry;
						break;
					end;
				end;
			end;
		end;
		if not self.PigManure then
			self.isPigManure = nil;
			print(self.ErrorTxt.."Schweinemast not found on Map");
		end;
	end;
	
	if (self.isCowManure or self.isPigManure) and self.Band.fill > 0 then
		if g_currentMission:getIsServer()  then
			local trailer = self.Band.siloTrailer;
			if self.Band.fill >= 4 and trailer ~= nil and not self.Band.fillDone then
				trailer:resetFillLevelIfNeeded(self.Band.fillType);
				local fillLevel = trailer:getFillLevel(self.Band.fillType);
				
				local siloAmount = 0;
				if self.isCowManure then
					siloAmount = g_currentMission.husbandries.cow.manureHeap.fillLevel;
				elseif self.PigManure then
					siloAmount = self.PigManure.manureHeap.FillLvl;
				end;
				
				if siloAmount > 0 and trailer:allowFillType(self.Band.fillType, false) then
					local deltaFillLevel = math.min(self.Band.fillLitersPerSecond*0.001*dt, siloAmount);
					trailer:setFillLevel(fillLevel+deltaFillLevel, self.Band.fillType);
					local newFillLevel = trailer:getFillLevel(self.Band.fillType);
  
					if fillLevel ~= newFillLevel then
						local setFillLvl = math.max(siloAmount-(newFillLevel-fillLevel), 0);
						if self.isCowManure then
							local object = g_currentMission:getNodeObject(g_currentMission.husbandries.cow.manureHeap.triggerId);
							object:setFillLevel(setFillLvl);
						elseif self.PigManure then
							self.PigManure:manureHeapSetFillLevel(setFillLvl, self.Band.fillType);
							self.PigManure.SendUpdate = true;
						end;
						self.Band:startFill();
					else
						self.Band.fillDone = true; -- trailer is full
						self.Band:stopFill();
					end;
  
				else
					self.Band.fillDone = true; -- silo is empty or trailer does not support fill type
					self.Band:stopFill();
				end;
			end;
		end;
	end;
	
	if self.isSameStrawGrass and self.Band.siloTrailer == nil then
		if self.Stroh then
			if g_currentMission:getSiloAmount(Fillable.FILLTYPE_BARLEY_WINDROW) > 0 then 
				self.Band.fillType = Fillable.FILLTYPE_BARLEY_WINDROW; 
			else
				self.Band.fillType = Fillable.FILLTYPE_WHEAT_WINDROW; 
			end; 
		else
			if g_currentMission:getSiloAmount(Fillable.FILLTYPE_GRASS_WINDROW) > 0 then 
				self.Band.fillType = Fillable.FILLTYPE_GRASS_WINDROW; 
			else
				self.Band.fillType = Fillable.FILLTYPE_DRYGRASS_WINDROW; 
			end;
		end;
	end;
end;
   
g_onCreateUtil.addOnCreateFunction("MapSiloBand", MapSiloBand.onCreate);
 