--
-- Specialization for OdeAZ by ls-team-international
--
-- @author  	irakls@ls-team-international
-- @version 	v1
-- @date  	07/07/13

OdeAZ = {};

function OdeAZ.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations); 
end;

function OdeAZ:load(xmlFile)
	--[[
	self.JointsAlertOn = Utils.getFilename("ESLimiter_hud.png", self.baseDirectory);
	self.JointsAlertOff = Utils.getFilename("ESLimiter_hud.png", self.baseDirectory);
    self.JointsAlertWidth = 0.2371;
	self.JointsAlertHeight = 0.039525;
    self.JointsAlertPosX = 0.7543;
    self.JointsAlertPosY = 0.1715;
    self.JointsAlertOnOverlay = Overlay:new("JointsAlertOn", self.JointsAlertOn, self.JointsAlertPosX, self.JointsAlertPosY, self.JointsAlertWidth, self.JointsAlertHeight);
	self.JointsAlertOffOverlay = Overlay:new("JointsAlertOff", self.JointsAlertOff, self.JointsAlertPosX, self.JointsAlertPosY, self.JointsAlertWidth, self.JointsAlertHeight);	
]]
	self.charIdAnim = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animKipBlok#Node"));
	self.clipIndexAnim = getXMLString(xmlFile, "vehicle.animKipBlok#animationClip");
	self.charId = getAnimCharacterSet(self.charIdAnim);
	self.clipIndex = getAnimClipIndex(self.charId, self.clipIndexAnim);		
	if self.clipIndex ~= nil then
		if self.clipIndex >= 0 then
			assignAnimTrackClip(self.charId, 0, self.clipIndex);
			setAnimTrackLoopState(self.charId, 0, false);		
			self.animDuration = getAnimClipDuration(self.charId, self.clipIndex);
		end;
	end;	
	self.trackTime = 0;				
	self.lastTrackTime = 0;				
	self.JointsBlocked = false;
	self.JointsBlockedAlert = self.time;
end;

function OdeAZ:update(dt)
	local inlocalarea = false;

	local jointDesc = self.componentJoints[1];
	local px, py, pz = getWorldTranslation(jointDesc.jointNode);
	local sx, sy, sz = project(px, py, pz);
	if not self:getIsActiveForInput() then
		if g_currentMission.player ~= nil then
			local pvx, pvy, pvz = getWorldTranslation(g_currentMission.player.rootNode);
			local farmerDistance = Utils.vector3Length(pvx-px, pvy-py, pvz-pz);
			if farmerDistance < 2 then
				inlocalarea = true;
				if not self.JointsBlocked then
					g_currentMission:addHelpButtonText(g_i18n:getText("JointsBlock"), InputBinding.JointsBlock);
					--self.JointsAlertOnOverlay:render();
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("JointsUnBlock"), InputBinding.JointsBlock);
					--self.JointsAlertOffOverlay:render();
				end;
			end;
		end;
	end;
	
	if inlocalarea then
		if InputBinding.hasEvent(InputBinding.JointsBlock) then
			local x,y,z = getRotation(self.components[1].node);
			local x1,y1,z1 = getRotation(self.components[2].node);
			if math.abs(y - y1) < 0.01 then
				self.JointsBlocked = not self.JointsBlocked;
				--Vehicle:playAttachSound();
				if self.JointsBlocked then
					setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, 0, 0);				
				else
					setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, math.rad(-120), math.rad(120));						
				end;
			else
				if sz <= 1 then
					self.JointsBlockedAlert = self.time+5000;
				end;
			end;
		end;
		if self.JointsBlockedAlert > self.time then
			renderText(sx, sy-0.0015, 0.02, g_i18n:getText("JointsBlockAlert"));
		else
		end;
	end;
end;

function OdeAZ:updateTick()
	if self.trackTime < 1 then 
		self.trackTime = 0;
	end;
	if self.trackTime > self.animDuration then
		self.trackTime = self.animDuration;
	end;
	if self.JointsBlocked then
		if self.trackTime < self.animDuration then
			self.trackTime = self.trackTime +25;			
		end;	
	else
		if self.trackTime > 0 then
			self.trackTime = self.trackTime -25;
		end;
	end;
	if self.lastTrackTime ~= self.trackTime then
					enableAnimTrack(self.charId, self.clipIndex);	
					setAnimTrackTime(self.charId, self.clipIndex, self.trackTime, true);
					disableAnimTrack(self.charId, self.clipIndex);
		self.lastTrackTime = self.trackTime;					
	end;	
end;

function OdeAZ:draw()
end;

function OdeAZ:delete()
end;

function OdeAZ:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OdeAZ:keyEvent(unicode, sym, modifier, isDown)
end;

function OdeAZ:onDetach()
end;

function OdeAZ:onAttach()
end; 

function OdeAZ:onLeave()
end;

function OdeAZ:onActivate()
end;

function OdeAZ:onDeactivate()
end;

function OdeAZ:CarrierWorkingTime(diffTime)
end; 
