--
-- AnimationMap
--
-- @author:    	Xentro (Marcus@Xentro.se)
-- @website:	www.Xentro.se
-- @history		v1.0   - 2014-11-08 - Initial implementation
-- 				v1.0.1 - 2014-12-18 - Warning if adding one of the default text to globalText
-- 

AnimationMap = {};
AnimationMap.baseDirectory = g_currentModDirectory;

addModEventListener(AnimationMap);

function AnimationMap:loadMap(name)
	g_currentMission.AnimationMapHuds = {};
	
	local mapFile;
	local baseDir = {};
	baseDir[1] = AnimationMap.baseDirectory;
	
	if g_currentMission.AnimationMapConfig ~= nil then
		if g_currentMission.AnimationMapConfig[1] ~= nil then
			mapFile = Utils.getFilename(g_currentMission.AnimationMapConfig[1], g_currentMission.AnimationMapConfig[2]);
		end;
		
		baseDir[2] = g_currentMission.AnimationMapConfig[2];
		
		local words = Utils.splitString("/", baseDir[2]);
		g_currentMission.AnimationMapConfig["mapName"] = words[table.getn(words) - 1];
		g_currentMission.AnimationMapConfig["mapDir"] = baseDir[2];
	end;
	
	local xmlFiles = {Utils.getFilename("AnimationMap.xml", AnimationMap.baseDirectory), mapFile};
	
	for k, file in pairs(xmlFiles) do
		if fileExists(file) then
			local xmlFile = loadXMLFile("fileXMLTemp", file);
			
			if g_currentMission.AnimationMapConfig ~= nil and g_currentMission.AnimationMapConfig["debug"] == nil then
				g_currentMission.AnimationMapConfig["debug"] = getXMLBool(xmlFile, "AnimationMap.Config#debug");
			end;
			
			if k >= 2 then -- we dont want to make this mod text global..
				local i = 0;
				while true do
					local key = string.format("AnimationMap.GlobalTexts.text(%d)", i);
					if not hasXMLProperty(xmlFile, key) then break; end;
					
					local name = getXMLString(xmlFile, key .. "#name");
					
					if name ~= nil and g_currentMission.AnimationMapConfig ~= nil then
						if not g_i18n:hasText(name) then
							g_i18n.globalI18N.texts[name] = _G[g_currentMission.AnimationMapConfig["mapName"]].g_i18n:getText(name);
						else
							print("AnimationMapTrigger - Warning: GlobalTexts (" .. name .. ") is set by the AnimtionMapTrigger mod, remove it from GlobalTexts.");
						end;
					end;
					
					i = i + 1;
				end;
			end;
			
			-- load hud overlays
			local i = 0;
			while true do
				local key = string.format("AnimationMap.Huds.Hud(%d)", i);
				if not hasXMLProperty(xmlFile, key) then break; end;
				
				local hudName = getXMLString(xmlFile, key .. "#name");
				
				if hudName ~= nil then 
					local filename = Utils.getFilename(getXMLString(xmlFile, key .. "#filename"), baseDir[k]);
					
					if fileExists(filename) then
						local x = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#x"), 0.92);
						local y = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#y"), 0.185);
						local width = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#width"), 0.056);
						local height = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#height"), 0.08);
						
						if g_currentMission.AnimationMapConfig ~= nil and Utils.getNoNil(g_currentMission.AnimationMapConfig["debug"], false) then
							if g_currentMission.AnimationMapHuds[hudName] ~= nil then
								print("AnimationMapTrigger - Debug: overlay hud " .. tostring(hudName) .. " have been replaced.");
							end;
						end;
						
						g_currentMission.AnimationMapHuds[hudName] = Overlay:new(hudName, filename, x, y, width, height);
						
						i = i + 1;
					else
						print("AnimationMapTrigger - Error: Hud file (" .. tostring(filename) .. ") can't be found!");
						break;
					end;
				else
					print("AnimationMapTrigger - Error: Invalid hud name (" .. tostring(hudName) .. ")");
					break;
				end;
			end;

			delete(xmlFile);
		else
			print("- xml file couldn't be found! " .. tostring(file));
		end;
	end;
	
	if g_currentMission.AnimationMapTriggers ~= nil then
		for name, trigger in pairs(g_currentMission.AnimationMapTriggers) do
			if trigger.finishLoad ~= nil then
				trigger:finishLoad(trigger);
			end;
		end;
	end;
end;

function AnimationMap:deleteMap()
	for i, hud in pairs(g_currentMission.AnimationMapHuds) do
		hud:delete();
	end;
	
	g_currentMission.AnimationMapHuds = nil;
	g_currentMission.AnimationMapTriggers = nil;
	g_currentMission.AnimationMapConfig = nil;
end;

function AnimationMap:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimationMap:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimationMap:update(dt)
end;

function AnimationMap:draw()
	if g_gui.currentGui == nil and g_currentMission.AnimationMapTriggers ~= nil then
		for name, trigger in pairs(g_currentMission.AnimationMapTriggers) do
			if trigger.draw ~= nil then
				trigger:draw(trigger);
			end;
		end;
	end;
end;