

ModEventMixFeederMoneyPay = {};
ModEventMixFeederMoneyPay_mt = Class(ModEventMixFeederMoneyPay, Event);
InitEventClass(ModEventMixFeederMoneyPay, "ModEventMixFeederMoneyPay");

function ModEventMixFeederMoneyPay:emptyNew()
	local self = Event:new(ModEventMixFeederMoneyPay_mt);
	self.className="ModEventMixFeederMoneyPay";
	return self;
end;

function ModEventMixFeederMoneyPay:new(pay)
	local self = ModEventMixFeederMoneyPay:emptyNew();
	self.pay = pay;
	return self;
end;

function ModEventMixFeederMoneyPay:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.pay);
end;

function ModEventMixFeederMoneyPay:readStream(streamId, connection)
	self.pay  = streamReadFloat32(streamId);
	self:run(connection);
end;

function ModEventMixFeederMoneyPay:run(connection)
	ModEventMixFeeder:moneyPay(self.pay, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(ModEventMixFeederMoneyPay:new(self.pay), nil, connection);
	end;  
end;

function ModEventMixFeederMoneyPay.sendEvent(pay, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ModEventMixFeederMoneyPay:new(pay), nil, nil);
		else
			g_client:getServerConnection():sendEvent(ModEventMixFeederMoneyPay:new(pay));
		end;
	end;
end;
