

MixFeederTriggerAndPlaying = {};
MixFeederTriggerAndPlaying_mt = Class(MixFeederTriggerAndPlaying, Event);
InitEventClass(MixFeederTriggerAndPlaying, "MixFeederTriggerAndPlaying");

function MixFeederTriggerAndPlaying:emptyNew()
	local self = Event:new(MixFeederTriggerAndPlaying_mt);
	self.className="MixFeederTriggerAndPlaying";
	return self;
end;

function MixFeederTriggerAndPlaying:new(object, feederStart, feederRound, playing, mixed, unload, inTrigger, triggerNumber, showHud, flapIsOpened, shapeIsInTrigger)
	local self = MixFeederTriggerAndPlaying:emptyNew();
	self.object = object;
	self.feederStart = feederStart;
	self.feederRound = feederRound;
	self.playing = playing;
	self.mixed = mixed;
	self.unload = unload;
	self.inTrigger = inTrigger;
	self.triggerNumber = triggerNumber;
	self.showHud = showHud;
	self.flapIsOpened = flapIsOpened;
	self.shapeIsInTrigger = shapeIsInTrigger;
	return self;
end;

function MixFeederTriggerAndPlaying:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.feederStart);
	streamWriteBool(streamId, self.feederRound);
	streamWriteBool(streamId, self.playing);
	streamWriteBool(streamId, self.mixed);
	streamWriteBool(streamId, self.unload);
	streamWriteBool(streamId, self.inTrigger);
	streamWriteInt8(streamId, self.triggerNumber);
	streamWriteBool(streamId, self.showHud);
	streamWriteBool(streamId, self.flapIsOpened);
	streamWriteBool(streamId, self.shapeIsInTrigger)

end;

function MixFeederTriggerAndPlaying:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.feederStart  = streamReadBool(streamId);
	self.feederRound  = streamReadBool(streamId);
	self.playing  = streamReadBool(streamId);
	self.mixed  = streamReadBool(streamId);
	self.unload  = streamReadBool(streamId);
	self.inTrigger  = streamReadBool(streamId);
	self.triggerNumber  = streamReadInt8(streamId);
	self.showHud  = streamReadBool(streamId);
	self.flapIsOpened  = streamReadBool(streamId);
	self.shapeIsInTrigger = streamReadBool(streamId);
	self:run(connection);
end;

function MixFeederTriggerAndPlaying:run(connection)
	self.object:triggerAndPlaying(self.feederStart, self.feederRound, self.playing, self.mixed, self.unload, self.inTrigger, self.triggerNumber, self.showHud, self.flapIsOpened, self.shapeIsInTrigger, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederTriggerAndPlaying:new(self.object, self.feederStart, self.feederRound, self.playing, self.mixed, self.unload, self.inTrigger, self.triggerNumber, self.showHud, self.flapIsOpened, self.shapeIsInTrigger), nil, connection, self.object);
	end;  
end;

function MixFeederTriggerAndPlaying.sendEvent(object, feederStart, feederRound, playing, mixed, unload, inTrigger, triggerNumber, showHud, flapIsOpened, shapeIsInTrigger, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederTriggerAndPlaying:new(object, feederStart, feederRound, playing, mixed, unload, inTrigger, triggerNumber, showHud, flapIsOpened, shapeIsInTrigger), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederTriggerAndPlaying:new(object, feederStart, feederRound, playing, mixed, unload, inTrigger, triggerNumber, showHud, flapIsOpened, shapeIsInTrigger));
		end;
	end;
end;
