

MixFeederToDrawFillType = {};
MixFeederToDrawFillType_mt = Class(MixFeederToDrawFillType, Event);
InitEventClass(MixFeederToDrawFillType, "MixFeederToDrawFillType");

function MixFeederToDrawFillType:emptyNew()
	local self = Event:new(MixFeederToDrawFillType_mt);
	self.className="MixFeederToDrawFillType";
	return self;
end;

function MixFeederToDrawFillType:new(object, fillType)
	local self = MixFeederToDrawFillType:emptyNew();
	self.object = object;
	self.fillType = fillType;
	return self;
end;

function MixFeederToDrawFillType:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.fillType);
end;

function MixFeederToDrawFillType:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.fillType  = streamReadString(streamId);
	self:run(connection);
end;

function MixFeederToDrawFillType:run(connection)
	self.object:toDrawFillType(self.fillType, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederToDrawFillType:new(self.object, self.fillType), nil, connection, self.object);
	end;  
end;

function MixFeederToDrawFillType.sendEvent(object, fillType, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederToDrawFillType:new(object, fillType), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederToDrawFillType:new(object, fillType));
		end;
	end;
end;
