

MixFeederSetNewStatisticValue = {};
MixFeederSetNewStatisticValue_mt = Class(MixFeederSetNewStatisticValue, Event);
InitEventClass(MixFeederSetNewStatisticValue, "MixFeederSetNewStatisticValue");

function MixFeederSetNewStatisticValue:emptyNew()
	local self = Event:new(MixFeederSetNewStatisticValue_mt);
	self.className="MixFeederSetNewStatisticValue";
	return self;
end;

function MixFeederSetNewStatisticValue:new(object, filltype, feeded, feededFood, feedSession, needCompo)
	local self = MixFeederSetNewStatisticValue:emptyNew();
	self.object = object;
	self.filltype = filltype;
	self.feeded = feeded;
	self.feededFood = feededFood;
	self.feedSession = feedSession;
	self.needCompo = needCompo;
	return self;
end;

function MixFeederSetNewStatisticValue:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.filltype);
	streamWriteFloat32(streamId, self.feeded);
	streamWriteFloat32(streamId, self.feededFood);
	streamWriteFloat32(streamId, self.feedSession);
	streamWriteFloat32(streamId, self.needCompo);
end;

function MixFeederSetNewStatisticValue:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.filltype  = streamReadString(streamId);
	self.feeded = streamReadFloat32(streamId);
	self.feededFood = streamReadFloat32(streamId);
	self.feedSession  = streamReadFloat32(streamId);
	self.needCompo  = streamReadFloat32(streamId);
	self:run(connection);
end;

function MixFeederSetNewStatisticValue:run(connection)
	self.object:setNewStatisticValue(self.filltype, self.feeded, self.feededFood, self.feedSession, self.needCompo, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederSetNewStatisticValue:new(self.object, self.filltype, self.feeded, self.feededFood, self.feedSession, self.needCompo), nil, connection, self.object);
	end;  
end;

function MixFeederSetNewStatisticValue.sendEvent(object, filltype, feeded, feededFood, feedSession, needCompo, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederSetNewStatisticValue:new(object, filltype, feeded, feededFood, feedSession, needCompo), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederSetNewStatisticValue:new(object, filltype, feeded, feededFood, feedSession, needCompo));
		end;
	end;
end;
