

MixFeederSetNewPercentageValues = {};
MixFeederSetNewPercentageValues_mt = Class(MixFeederSetNewPercentageValues, Event);
InitEventClass(MixFeederSetNewPercentageValues, "MixFeederSetNewPercentageValues");

function MixFeederSetNewPercentageValues:emptyNew()
	local self = Event:new(MixFeederSetNewPercentageValues_mt);
	self.className="MixFeederSetNewPercentageValues";
	return self;
end;

function MixFeederSetNewPercentageValues:new(object, feederType, value)
	local self = MixFeederSetNewPercentageValues:emptyNew();
	self.object = object;
	self.feederType = feederType;
	self.value = value;
	return self;
end;

function MixFeederSetNewPercentageValues:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.feederType);
	streamWriteFloat32(streamId, self.value);
end;

function MixFeederSetNewPercentageValues:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.feederType  = streamReadString(streamId);
	self.value = streamReadFloat32(streamId);
	self:run(connection);
end;

function MixFeederSetNewPercentageValues:run(connection)
	self.object:setNewPercentageValues(self.feederType, self.value, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederSetNewPercentageValues:new(self.object, self.feederType, self.value), nil, connection, self.object);
	end;  
end;

function MixFeederSetNewPercentageValues.sendEvent(object, feederType, value, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederSetNewPercentageValues:new(object, feederType, value), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederSetNewPercentageValues:new(object, feederType, value));
		end;
	end;
end;
