

MixFeederSetNewFeedingTimes = {};
MixFeederSetNewFeedingTimes_mt = Class(MixFeederSetNewFeedingTimes, Event);
InitEventClass(MixFeederSetNewFeedingTimes, "MixFeederSetNewFeedingTimes");

function MixFeederSetNewFeedingTimes:emptyNew()
	local self = Event:new(MixFeederSetNewFeedingTimes_mt);
	self.className="MixFeederSetNewFeedingTimes";
	return self;
end;

function MixFeederSetNewFeedingTimes:new(object, tablePlace, newTime, timeCalculate)
	local self = MixFeederSetNewFeedingTimes:emptyNew();
	self.object = object;
	self.tablePlace = tablePlace;
	self.newTime = newTime;
	self.timeCalculate = timeCalculate;
	return self;
end;

function MixFeederSetNewFeedingTimes:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.tablePlace);
	streamWriteInt32(streamId, self.newTime);
	streamWriteBool(streamId, self.timeCalculate);
end;

function MixFeederSetNewFeedingTimes:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.tablePlace  = streamReadInt8(streamId);
	self.newTime = streamReadInt32(streamId);
	self.timeCalculate = streamReadBool(streamId);
	self:run(connection);
end;

function MixFeederSetNewFeedingTimes:run(connection)
	self.object:setNewFeedingTimes(self.tablePlace, self.newTime, self.timeCalculate, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederSetNewFeedingTimes:new(self.object, self.tablePlace, self.newTime, self.timeCalculate), nil, connection, self.object);
	end;  
end;

function MixFeederSetNewFeedingTimes.sendEvent(object, tablePlace, newTime, timeCalculate, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederSetNewFeedingTimes:new(object, tablePlace, newTime, timeCalculate), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederSetNewFeedingTimes:new(object, tablePlace, newTime, timeCalculate));
		end;
	end;
end;
