

MixFeederSetFeederValue = {};
MixFeederSetFeederValue_mt = Class(MixFeederSetFeederValue, Event);
InitEventClass(MixFeederSetFeederValue, "MixFeederSetFeederValue");

function MixFeederSetFeederValue:emptyNew()
	local self = Event:new(MixFeederSetFeederValue_mt);
	self.className="MixFeederSetFeederValue";
	return self;
end;

function MixFeederSetFeederValue:new(object, feederFillLevel, feederCapacity, updatePlanes, updateForage, fillType)
	local self = MixFeederSetFeederValue:emptyNew();
	self.object = object;
	self.feederFillLevel = feederFillLevel;
	self.feederCapacity = feederCapacity;
	self.updatePlanes = updatePlanes;
	self.updateForage = updateForage;
	self.fillType = fillType;
	return self;
end;

function MixFeederSetFeederValue:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.feederFillLevel);
	streamWriteFloat32(streamId, self.feederCapacity);
	streamWriteBool(streamId, self.updatePlanes);
	streamWriteBool(streamId, self.updateForage);
	streamWriteString(streamId, self.fillType);
end;

function MixFeederSetFeederValue:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.feederFillLevel = streamReadFloat32(streamId);
	self.feederCapacity = streamReadFloat32(streamId);
	self.updatePlanes  = streamReadBool(streamId);
	self.updateForage  = streamReadBool(streamId);
	self.fillType  = streamReadString(streamId);
	self:run(connection);
end;

function MixFeederSetFeederValue:run(connection)
	self.object:setFeederValue(self.feederFillLevel, self.feederCapacity, self.updatePlanes, self.updateForage, self.fillType, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederSetFeederValue:new(self.object, self.feederFillLevel, self.feederCapacity, self.updatePlanes, self.updateForage, self.fillType), nil, connection, self.object);
	end;  
end;

function MixFeederSetFeederValue.sendEvent(object, feederFillLevel, feederCapacity, updatePlanes, updateForage, fillType, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederSetFeederValue:new(object, feederFillLevel, feederCapacity, updatePlanes, updateForage, fillType), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederSetFeederValue:new(object, feederFillLevel, feederCapacity, updatePlanes, updateForage, fillType));
		end;
	end;
end;
