

MixFeederSetBunkerCapacity = {};
MixFeederSetBunkerCapacity_mt = Class(MixFeederSetBunkerCapacity, Event);
InitEventClass(MixFeederSetBunkerCapacity, "MixFeederSetBunkerCapacity");

function MixFeederSetBunkerCapacity:emptyNew()
	local self = Event:new(MixFeederSetBunkerCapacity_mt);
	self.className="MixFeederSetBunkerCapacity";
	return self;
end;

function MixFeederSetBunkerCapacity:new(object, all, useCapacity, filltype)
	local self = MixFeederSetBunkerCapacity:emptyNew();
	self.object = object;
	self.all = all;
	self.useCapacity = useCapacity;
	self.filltype = filltype;
	return self;
end;

function MixFeederSetBunkerCapacity:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.all);
	streamWriteBool(streamId, self.useCapacity);
	streamWriteString(streamId, self.filltype);
end;

function MixFeederSetBunkerCapacity:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.all = streamReadBool(streamId);
	self.useCapacity = streamReadBool(streamId);
	self.filltype  = streamReadString(streamId);
	self:run(connection);
end;

function MixFeederSetBunkerCapacity:run(connection)
	self.object:setBunkerCapacity(self.all, self.useCapacity, self.filltype, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederSetBunkerCapacity:new(self.object, self.all, self.useCapacity, self.filltype), nil, connection, self.object);
	end;  
end;

function MixFeederSetBunkerCapacity.sendEvent(object, all, useCapacity, filltype, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederSetBunkerCapacity:new(object, all, useCapacity, filltype), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederSetBunkerCapacity:new(object, all, useCapacity, filltype));
		end;
	end;
end;
