

MixFeederOnActivateChange = {};
MixFeederOnActivateChange_mt = Class(MixFeederOnActivateChange, Event);
InitEventClass(MixFeederOnActivateChange, "MixFeederOnActivateChange");

function MixFeederOnActivateChange:emptyNew()
	local self = Event:new(MixFeederOnActivateChange_mt);
	self.className="MixFeederOnActivateChange";
	return self;
end;

function MixFeederOnActivateChange:new(object, active)
	local self = MixFeederOnActivateChange:emptyNew();
	self.object = object;
	self.active = active;
	return self;
end;

function MixFeederOnActivateChange:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.active);

end;

function MixFeederOnActivateChange:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.active  = streamReadBool(streamId);
	self:run(connection);
end;

function MixFeederOnActivateChange:run(connection)
	self.object:onActivateChange(self.active, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederOnActivateChange:new(self.object, self.active), nil, connection, self.object);
	end;  
end;

function MixFeederOnActivateChange.sendEvent(object, active, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederOnActivateChange:new(object, active), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederOnActivateChange:new(object, active));
		end;
	end;
end;
