

MixFeederNumAnimSet = {};
MixFeederNumAnimSet_mt = Class(MixFeederNumAnimSet, Event);
InitEventClass(MixFeederNumAnimSet, "MixFeederNumAnimSet");

function MixFeederNumAnimSet:emptyNew()
	local self = Event:new(MixFeederNumAnimSet_mt);
	self.className="MixFeederNumAnimSet";
	return self;
end;

function MixFeederNumAnimSet:new(object, numAnimal)
	local self = MixFeederNumAnimSet:emptyNew();
	self.object = object;
	self.numAnimal = numAnimal;
	return self;
end;

function MixFeederNumAnimSet:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt16(streamId, self.numAnimal);
end;

function MixFeederNumAnimSet:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.numAnimal  = streamReadInt16(streamId);
	self:run(connection);
end;

function MixFeederNumAnimSet:run(connection)
	self.object:numAnimSet(self.numAnimal, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederNumAnimSet:new(self.object, self.numAnimal), nil, connection, self.object);
	end;  
end;

function MixFeederNumAnimSet.sendEvent(object, numAnimal, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederNumAnimSet:new(object, numAnimal), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederNumAnimSet:new(object, numAnimal));
		end;
	end;
end;
