

MixFeederMoreNeedSetEvent = {};
MixFeederMoreNeedSetEvent_mt = Class(MixFeederMoreNeedSetEvent, Event);
InitEventClass(MixFeederMoreNeedSetEvent, "MixFeederMoreNeedSetEvent");

function MixFeederMoreNeedSetEvent:emptyNew()
	local self = Event:new(MixFeederMoreNeedSetEvent_mt);
	self.className="MixFeederMoreNeedSetEvent";
	return self;
end;

function MixFeederMoreNeedSetEvent:new(object, more)
	local self = MixFeederMoreNeedSetEvent:emptyNew();
	self.object = object;
	self.more = more;
	return self;
end;

function MixFeederMoreNeedSetEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.more);
end;

function MixFeederMoreNeedSetEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.more  = streamReadInt8(streamId);
	self:run(connection);
end;

function MixFeederMoreNeedSetEvent:run(connection)
	self.object:moreNeedSet(self.more, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederMoreNeedSetEvent:new(self.object, self.more), nil, connection, self.object);
	end;  
end;

function MixFeederMoreNeedSetEvent.sendEvent(object, more, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederMoreNeedSetEvent:new(object, more), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederMoreNeedSetEvent:new(object, more));
		end;
	end;
end;
