

MixFeederMixingUpdatePlanes = {};
MixFeederMixingUpdatePlanes_mt = Class(MixFeederMixingUpdatePlanes, Event);
InitEventClass(MixFeederMixingUpdatePlanes, "MixFeederMixingUpdatePlanes");

function MixFeederMixingUpdatePlanes:emptyNew()
	local self = Event:new(MixFeederMixingUpdatePlanes_mt);
	self.className="MixFeederMixingUpdatePlanes";
	return self;
end;

function MixFeederMixingUpdatePlanes:new(object, fillType, amount)
	local self = MixFeederMixingUpdatePlanes:emptyNew();
	self.object = object;
	self.fillType = fillType;
	self.amount = amount;
	return self;
end;

function MixFeederMixingUpdatePlanes:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteString(streamId, self.fillType);
	streamWriteFloat32(streamId, self.amount);
end;

function MixFeederMixingUpdatePlanes:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.fillType  = streamReadString(streamId);
	self.amount = streamReadFloat32(streamId);
	self:run(connection);
end;

function MixFeederMixingUpdatePlanes:run(connection)
	self.object:mixingUpdatePlanes(self.fillType, self.amount, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederMixingUpdatePlanes:new(self.object, self.fillType, self.amount), nil, connection, self.object);
	end;  
end;

function MixFeederMixingUpdatePlanes.sendEvent(object, fillType, amount, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederMixingUpdatePlanes:new(object, fillType, amount), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederMixingUpdatePlanes:new(object, fillType, amount));
		end;
	end;
end;
