
MixFeederFeederMBOChange = {};
MixFeederFeederMBOChange_mt = Class(MixFeederFeederMBOChange, Event);
InitEventClass(MixFeederFeederMBOChange, "MixFeederFeederMBOChange");

function MixFeederFeederMBOChange:emptyNew()
	local self = Event:new(MixFeederFeederMBOChange_mt);
	self.className = "MixFeederFeederMBOChange";
	return self;
end;

function MixFeederFeederMBOChange:new(object, buyed)
	local self = MixFeederFeederMBOChange:emptyNew()
	self.object = object;
	self.buyed = buyed;
	return self;
end;

function MixFeederFeederMBOChange:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.buyed);
end;

function MixFeederFeederMBOChange:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.buyed  = streamReadBool(streamId);
	self:run(connection);
end;

function MixFeederFeederMBOChange:run(connection)
	self.object:feederMBOChange(self.buyed, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MixFeederFeederMBOChange:new(self.object, self.buyed), nil, connection, self.object);
	end;
end;

function MixFeederFeederMBOChange.sendEvent(object, buyed, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederFeederMBOChange:new(object, buyed), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederFeederMBOChange:new(object, buyed));
		end;
	end;
end;

