﻿

MixFeederEndRound = {};
MixFeederEndRound_mt = Class(MixFeederEndRound, Event);
InitEventClass(MixFeederEndRound, "MixFeederEndRound");

function MixFeederEndRound:emptyNew()
	local self = Event:new(MixFeederEndRound_mt);
	self.className = "MixFeederEndRound";
	return self;
end;

function MixFeederEndRound:new(object, round, anotherRound, abort)
	local self = MixFeederEndRound:emptyNew()
	self.object = object;
	self.round = round;
	self.anotherRound = anotherRound;
	self.abort = abort;
	return self;
end;

function MixFeederEndRound:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.round);
	streamWriteBool(streamId, self.anotherRound);
	streamWriteBool(streamId, self.abort);
end;

function MixFeederEndRound:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.round = streamReadBool(streamId);
	self.anotherRound = streamReadBool(streamId);
	self.abort = streamReadBool(streamId);
	self:run(connection);
end;

function MixFeederEndRound:run(connection)
	self.object:endRound(self.round, self.anotherRound, self.abort, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MixFeederEndRound:new(self.object, self.round, self.anotherRound,self.abort), nil, connection, self.object);
	end;
end;

function MixFeederEndRound.sendEvent(object, round, anotherRound, abort, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederEndRound:new(object, round, anotherRound, abort), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederEndRound:new(object, round, anotherRound, abort));
		end;
	end;
end;

