

MixFeederChangeSpeedEvent = {};
MixFeederChangeSpeedEvent_mt = Class(MixFeederChangeSpeedEvent, Event);
InitEventClass(MixFeederChangeSpeedEvent, "MixFeederChangeSpeedEvent");

function MixFeederChangeSpeedEvent:emptyNew()
	local self = Event:new(MixFeederChangeSpeedEvent_mt);
	self.className="MixFeederChangeSpeedEvent";
	return self;
end;

function MixFeederChangeSpeedEvent:new(object, driveSpeed, unloadSpeed)
	local self = MixFeederChangeSpeedEvent:emptyNew();
	self.object = object;
	self.driveSpeed = driveSpeed;
	self.unloadSpeed = unloadSpeed;
	return self;
end;

function MixFeederChangeSpeedEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.driveSpeed);
	streamWriteFloat32(streamId, self.unloadSpeed);
end;

function MixFeederChangeSpeedEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.driveSpeed  = streamReadFloat32(streamId);
	self.unloadSpeed  = streamReadFloat32(streamId);
	self:run(connection);
end;

function MixFeederChangeSpeedEvent:run(connection)
	self.object:changeSpeedEvent(self.driveSpeed, self.unloadSpeed, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederChangeSpeedEvent:new(self.object, self.driveSpeed, self.unloadSpeed), nil, connection, self.object);
	end;  
end;

function MixFeederChangeSpeedEvent.sendEvent(object, driveSpeed, unloadSpeed, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederChangeSpeedEvent:new(object, driveSpeed, unloadSpeed), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederChangeSpeedEvent:new(object, driveSpeed, unloadSpeed));
		end;
	end;
end;
