

MixFeederChangeRollersRotate = {};
MixFeederChangeRollersRotate_mt = Class(MixFeederChangeRollersRotate, Event);
InitEventClass(MixFeederChangeRollersRotate, "MixFeederChangeRollersRotate");

function MixFeederChangeRollersRotate:emptyNew()
	local self = Event:new(MixFeederChangeRollersRotate_mt);
	self.className="MixFeederChangeRollersRotate";
	return self;
end;

function MixFeederChangeRollersRotate:new(object, mixing, unloading, drive)
	local self = MixFeederChangeRollersRotate:emptyNew();
	self.object = object;
	self.mixing = mixing;
	self.unloading = unloading;
	self.drive = drive;
	return self;
end;

function MixFeederChangeRollersRotate:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.mixing);
	streamWriteBool(streamId, self.unloading);
	streamWriteBool(streamId, self.drive);

end;

function MixFeederChangeRollersRotate:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.mixing  = streamReadBool(streamId);
	self.unloading  = streamReadBool(streamId);
	self.drive  = streamReadBool(streamId);
	self:run(connection);
end;

function MixFeederChangeRollersRotate:run(connection)
	self.object:changeRollersRotate(self.mixing, self.unloading, self.drive, true);
  
	if not connection:getIsServer() then 
		g_server:broadcastEvent(MixFeederChangeRollersRotate:new(self.object, self.mixing, self.unloading, self.drive), nil, connection, self.object);
	end;  
end;

function MixFeederChangeRollersRotate.sendEvent(object, mixing, unloading, drive, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MixFeederChangeRollersRotate:new(object, mixing, unloading, drive), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(MixFeederChangeRollersRotate:new(object, mixing, unloading, drive));
		end;
	end;
end;
