﻿--
--
--		MapBuayableObjetcs_drawPart
--@date: 02/10/2012
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0		release
--			v2.0		fix when no Master Trigger is bulid in
--			v3.0		26/11/14		convert to Ls15
--			v3.1		14/12/14		fix Savegame load when leave the game only to mainmenu, thanks to user "Nerezza"
--			v3.2		25/01/2015		create gui with rafftnixGui.lua for MasterTrigger
--			v3.3		14/02/2015		add a mboListener and talk to them. Thanks to Heady
--
--darf in jede Map eingebaut werden, MapBuayableObjetcs.zip darf nicht neu hochgeladen werden
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission
--
	--print("   Map: Buyable Objects(Master) v3.3  by Bluebaby210 loaded!");

masterTriggerAllowed = 0;

if BaseMission.mboBuyListener == nil then
	BaseMission.mboBuyListener = {};
	print("  Register Variable: BaseMission.mboBuyListener");
end;


ObjectBuy = {};
ObjectBuy.drawParts = {};
ObjectBuy.drawPartsIcon = {};
ObjectBuy.drawPartsMaster = {};
ObjectBuy.anotherTrigger = {};

function ObjectBuy:loadMap(name)

	self.version = 3.3;
	self.mapName = g_currentMission.missionInfo.mapId

	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.saveXMLFile = dir .. "/MapBuyableObjects.xml";
	if g_currentMission.missionInfo.playTime == 0 then
		self.firstRun = false;
	else
		self.firstRun = true;
	end;
	
	self.updateMBOListeners = true;
	self.triggerUpdate = true;
	
	if #ObjectBuy.drawPartsMaster ~= 0 then
		ObjectBuy.drawPartsMaster[1].masterTriggerGUI = MBO_MasterTrigger_GUI:new();
	end;
	
	self.openGui = true; 

end;

function ObjectBuy:deleteMap()
	
	if #ObjectBuy.drawParts ~= 0 then
		for k=1,#ObjectBuy.drawParts do 
			ObjectBuy.drawParts[k] = nil;
		end;
	end;
	if #ObjectBuy.drawPartsIcon ~= 0 then
		for k=1,#ObjectBuy.drawPartsIcon do 
			ObjectBuy.drawPartsIcon[k] = nil;
		end;
	end;
	if #ObjectBuy.drawPartsMaster ~= 0 then
		for k=1,#ObjectBuy.drawPartsMaster do 
			ObjectBuy.drawPartsMaster[k] = nil;
		end;
	end;
	if #ObjectBuy.anotherTrigger ~= 0 then
		for k=1,#ObjectBuy.anotherTrigger do 
			ObjectBuy.anotherTrigger[k] = nil;
		end;
	end;

end;

function ObjectBuy:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ObjectBuy:keyEvent(unicode, sym, modifier, isDown)
end;

function ObjectBuy:readStream(streamId, connection)
	self.triggerUpdate = streamReadBool(streamId);
	self.updateMBOListeners = streamReadBool(streamId);
end;

function ObjectBuy:writeStream(streamId, connection)
	streamWriteBool(streamId, self.triggerUpdate);
	streamWriteBool(streamId, self.updateMBOListeners);
end;

function ObjectBuy:update(dt)

	if g_server ~= nil then
		if self.updateMBOListeners then
			if #g_currentMission.mboBuyListener > 0 then
				for i=1, #g_currentMission.mboBuyListener do
					local entry = g_currentMission.mboBuyListener[i];
					if entry.object.buyMBO ~= nil then
						entry.object:buyMBO(nil);
					end;
				end;
			end;
			self.updateMBOListeners = false;
		end;
		if self.triggerUpdate then
			if #ObjectBuy.drawParts ~= 0 then
				for i=1, #ObjectBuy.drawParts do
					ObjectBuy.drawParts[i]:visibility(false, false, 3);
				end;
			end;
			self.triggerUpdate = false;
		end;
		if self.firstRun then
			ObjectBuy:loadBuyableObjectFromXML();
		end;
		if masterTriggerAllowed == 0 and not self.firstRun then
			if self.openGui then
				if #ObjectBuy.drawPartsMaster ~= 0 then
					ObjectBuy.drawPartsMaster[1]:saveLoad(masterTriggerAllowed,self.firstRun)
					self.openGui = false;
				end;
			end;
		end;
	end;

end;

function ObjectBuy:draw()
	
	if #ObjectBuy.drawParts ~= 0 then
		for i=1, #ObjectBuy.drawParts do
			ObjectBuy.drawParts[i]:draw();
		end;
	end;
	if #ObjectBuy.drawPartsIcon ~= 0 then
		for i=1, #ObjectBuy.drawPartsIcon do
			ObjectBuy.drawPartsIcon[i]:draw();
		end;
	end;
	if #ObjectBuy.drawPartsMaster ~= 0 then
		for i=1, #ObjectBuy.drawPartsMaster do
			ObjectBuy.drawPartsMaster[i]:draw();
		end;
	end;

end;

local CareerScreenSaveSavegame = g_careerScreen.saveSavegame;
g_careerScreen.saveSavegame = function(self,savegame)
	CareerScreenSaveSavegame(self,savegame);
	ObjectBuy:saveBuyableObjectToXML();
end;

function ObjectBuy:loadBuyableObjectFromXML()

	if #self.drawParts ~= 0 then --
		if fileExists(self.saveXMLFile) then
			local xmlFile = loadXMLFile("MapBuyableObjects", self.saveXMLFile);
			local a = Utils.getNoNil(getXMLString(xmlFile, "BuyableObjects#mapIdentifier"), nil);
				if (a == self.mapName) then	
					local c = Utils.getNoNil(getXMLInt(xmlFile, "BuyableObjects#withMapBuyableObjects"), 1);
					--Prüfen ob MasterTrigger verbaut ist, wenn nicht dann masterTriggerAllowed umstellen von 0 auf 1.
					if #ObjectBuy.drawPartsMaster == 0 then
						c = 1;
					end;
					masterTriggerAllowed = c;
					if c == 1 then
						for i=1, #self.drawParts do
								local key = ("BuyableObjects."..ObjectBuy.drawParts[i].buyableText.."");
								ObjectBuy.drawParts[i].newNumber = Utils.getNoNil(getXMLInt(xmlFile, key.."#BuyObject_Buy"),0);
								ObjectBuy.drawParts[i].newNum = Utils.getNoNil(getXMLInt(xmlFile, key.."#BuyObject_Delete"),1);
								ObjectBuy.drawParts[i].newTri = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trigger_Buy"),0);
								ObjectBuy.drawParts[i].newDelTri = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trigger_Delete"),1);
								ObjectBuy.drawParts[i].newTransObj = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trans_Objects"),0);
								--savegame laden, wenn savegame nummer ist wie gekauft/nicht da, dann einmal visibilitiy aufrufen um Event zu senden.					
								if (ObjectBuy.drawParts[i].newNumber == 1 or ObjectBuy.drawParts[i].newNumber == 3) and (ObjectBuy.drawParts[i].newNum == 0 or ObjectBuy.drawParts[i].newNum == 3) and (ObjectBuy.drawParts[i].newTri == 1 or ObjectBuy.drawParts[i].newTri == 3) and (ObjectBuy.drawParts[i].newDelTri == 0 or ObjectBuy.drawParts[i].newDelTri == 3) and (ObjectBuy.drawParts[i].newTransObj == 1 or ObjectBuy.drawParts[i].newTransObj == 3) then
									ObjectBuy.drawParts[i].hasPressedBuy = 1;
									ObjectBuy.drawParts[i].saveGameLoad = true;
									ObjectBuy.drawParts[i].payedPrice = true;
									ObjectBuy.drawParts[i]:visibility(true, false, 1);
									ObjectBuy.drawParts[i].infoToOthers = false;
								end;
						end;

						for i=1, #self.drawPartsIcon do
								local key = ("BuyableObjects."..ObjectBuy.drawPartsIcon[i].iconText.."");
								ObjectBuy.drawPartsIcon[i].newNumberIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#BuyObject_Buy"),0);
								ObjectBuy.drawPartsIcon[i].newNumIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#BuyObject_Delete"),1);
								ObjectBuy.drawPartsIcon[i].newTriIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trigger_Buy"),0);
								ObjectBuy.drawPartsIcon[i].newDelTriIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trigger_Delete"),1);
								ObjectBuy.drawPartsIcon[i].newTransIcon = Utils.getNoNil(getXMLInt(xmlFile, key.."#Trans_Objects"),0);

								--savegame laden, wenn savegame nummer ist wie gekauft/nicht da, dann einmal visibilitiy aufrufen um Event zu senden.					
								if (ObjectBuy.drawPartsIcon[i].newNumberIcon == 1 or ObjectBuy.drawPartsIcon[i].newNumberIcon == 3) and (ObjectBuy.drawPartsIcon[i].newNumIcon == 0 or ObjectBuy.drawPartsIcon[i].newNumIcon == 3) and (ObjectBuy.drawPartsIcon[i].newTriIcon == 1 or ObjectBuy.drawPartsIcon[i].newTriIcon == 3) and (ObjectBuy.drawPartsIcon[i].newDelTriIcon == 0 or ObjectBuy.drawPartsIcon[i].newDelTriIcon == 3) and (ObjectBuy.drawPartsIcon[i].newTransIcon == 1 or ObjectBuy.drawPartsIcon[i].newTransIcon == 3) then
									ObjectBuy.drawPartsIcon[i]:visibilityIcon(true);
								end;
						end;
						print("   MapBuyableObjects: Savegame states was loaded.");
						
						-- if #ObjectBuy.drawPartsMaster ~= 0 then
							-- ObjectBuy.drawPartsMaster[1]:withoutMBO(false)
						-- end;

					elseif c == 2 then
						for i=1, #self.drawParts do
							ObjectBuy.drawParts[i].hasPressedBuy = 1;
							ObjectBuy.drawParts[i].saveGameLoad = true;
							ObjectBuy.drawParts[i].payedPrice = true;
							ObjectBuy.drawParts[i]:visibility(true, false, 1);
							ObjectBuy.drawParts[i].infoToOthers = false;
						end;
						for i=1, #self.drawPartsIcon do
							ObjectBuy.drawPartsIcon[i]:visibilityIcon(true);
						end;
						print("   MapBuyableObjects: Play without buyable objects, all objects are there.");
					elseif c == 0 then
						print("   MapBuyableObjects: MasterTrigger, you have to decide.");
					
					end;
					local b = Utils.getNoNil(getXMLInt(xmlFile, "BuyableObjects#numberOfObjects"), 0);
						if b > #self.drawParts then
							print("   MapBuyableObjects: Object deleted from map.");
						elseif b < #self.drawParts then 
							print("   MapBuyableObjects: New Object added to map.");
						end;

					
					self.firstRun = false;
					
					if masterTriggerAllowed == 0 then
						ObjectBuy.drawPartsMaster[1]:saveLoad(masterTriggerAllowed,self.firstRun)
					end;

				else
					print("Warning: MapBuyableObjects can't load ", self.saveXMLFile, ": Name of the current map does not match the match in the savegame.");
				end;
				delete(xmlFile);
		else
			print("Warning: MapBuyableObjects can't load ", self.saveXMLFile, ": Playing time is not 0, but Savegame XML does not exist.");
		end;
	end; --

end;

function ObjectBuy:saveBuyableObjectToXML()

	if #self.drawParts ~= 0 then 
		local xmlFile = createXMLFile('MapBuyableObjects', self.saveXMLFile, 'BuyableObjects');
		if xmlFile ~= nil then
			local key = 'BuyableObjects';
			setXMLString(xmlFile, key .. '#mapIdentifier', self.mapName);
			setXMLInt(xmlFile, key .. '#numberOfObjects', #ObjectBuy.drawParts);
			setXMLInt(xmlFile, key .. '#withMapBuyableObjects', masterTriggerAllowed);
		
			for i=1, #ObjectBuy.drawParts do
				key = 'BuyableObjects.' .. ObjectBuy.drawParts[i].buyableText;
				setXMLInt(xmlFile, key .. '#BuyObject_Buy', ObjectBuy.drawParts[i].toBuy);
				setXMLInt(xmlFile, key .. '#BuyObject_Delete', ObjectBuy.drawParts[i].toDelete);
				setXMLInt(xmlFile, key .. '#Trigger_Buy', ObjectBuy.drawParts[i].toTrigger);
				setXMLInt(xmlFile, key .. '#Trigger_Delete', ObjectBuy.drawParts[i].toDeleteTrigger);
				setXMLInt(xmlFile, key .. '#Trans_Objects', ObjectBuy.drawParts[i].toTrans);
			end;
			saveXMLFile(xmlFile);
			delete(xmlFile);
		end;	
	end;
end;

--[==[function ObjectBuy:loadFromAttributesAndNodes(xmlFile, Key)
	local master = Utils.getNoNil(getXMLInt(xmlFile, Key.."#withMapBuyableObjects"), nil);
	if master == nil then
		ObjectBuy:loadBuyableObjectFromXML()
	end;
	if master == 1 then
		if #ObjectBuy.drawParts ~= 0 then
			for i=1, #ObjectBuy.drawParts do
				ObjectBuy.drawParts[i]:visibility(false, false, 3);
			end;
		end;
		
		for i=1, #self.drawParts do
			local textkey = Key..string.format("."..ObjectBuy.drawParts[i].buyableText.."");
			local toBuy = getXMLInt(xmlFile, textkey.."#BuyObject_Buy");
			local toDelete = getXMLInt(xmlFile, textkey.."#BuyObject_Delete");
			local toTrigger = getXMLInt(xmlFile, textkey.."#Trigger_Buy");
			local toTriggerDelete = getXMLInt(xmlFile, textkey.."#Trigger_Delete");
			local toTrans = getXMLInt(xmlFile, textkey.."#Trans_Objects");
			if (toBuy == 1 or toBuy == 3) and (toDelete == 0 or toDelete == 3) and (toTrigger == 1 or toTrigger == 3) and (toTriggerDelete == 0 or toTriggerDelete == 3) and (toTrans == 1 or toTrans == 3) then
				ObjectBuy.drawParts[i].hasPressedBuy = 1;
				ObjectBuy.drawParts[i].saveGameLoad = true;
				ObjectBuy.drawParts[i].payedPrice = true;
				ObjectBuy.drawParts[i]:visibility(true, false, 1);
				ObjectBuy.drawParts[i].infoToOthers = false;
			end;
		end;
		
		for a=1, #self.drawParts do
			local textname = Key..string.format("."..ObjectBuy.drawPartsIcon[a].iconText.."");
			local toBuyIcon = getXMLInt(xmlFile, textname.."#BuyObject_Buy");
			local toDeleteIcon = getXMLInt(xmlFile, textname.."#BuyObject_Delete");
			local toTriggerIcon = getXMLInt(xmlFile, textname.."#Trigger_Buy");
			local toTriggerDeleteIcon = getXMLInt(xmlFile, textname.."#Trigger_Delete");
			local toTransIcon = getXMLInt(xmlFile, textname.."#Trans_Objects");
			if (toBuyIcon == 1 or toBuyIcon == 3) and (toDeleteIcon == 0 or toDeleteIcon == 3) and (toTriggerIcon == 1 or toTriggerIcon == 3) and (toTriggerDeleteIcon == 0 or toTriggerDeleteIcon == 3) and (toTransIcon == 1 or toTransIcon == 3) then
				ObjectBuy.drawPartsIcon[a]:visibilityIcon(true);
			end;
		end;
		
		if #ObjectBuy.drawPartsMaster ~= 0 then
			ObjectBuy.drawPartsMaster[1]:withoutMBO(false)
		end;
		
		masterTriggerAllowed = 1;
		print("   MapBuyableObjects: Savegame states was loaded.");

	elseif master == 2 then
		if #ObjectBuy.drawParts ~= 0 then
			for i=1, #ObjectBuy.drawParts do
				ObjectBuy.drawParts[i]:visibility(false, false, 3);
			end;
		end;
		for i=1, #self.drawParts do
			ObjectBuy.drawParts[i].hasPressedBuy = 1;
			ObjectBuy.drawParts[i].saveGameLoad = true;
			ObjectBuy.drawParts[i].payedPrice = true;
			ObjectBuy.drawParts[i]:visibility(true, false, 1);
			ObjectBuy.drawParts[i].infoToOthers = false;
		end;
		
		for i=1, #self.drawPartsIcon do
			ObjectBuy.drawPartsIcon[i]:visibilityIcon(true);
		end;
		
		if #ObjectBuy.drawPartsMaster ~= 0 then
			ObjectBuy.drawPartsMaster[1]:withoutMBO(false)
		end;
		masterTriggerAllowed = 2;
		
		print("   MapBuyableObjects: Play without buyable objects, all objects are there.");
	end;

	return true;
end;

function ObjectBuy:getSaveAttributesAndNodes(nodeIdent)

	local attributes = 'BuyableObjects="'..#ObjectBuy.drawParts..'" withMapBuyableObjects="'..masterTriggerAllowed..'"';
	local nodes = "";
	
	local buyableObjects = 0;
	for i=1, #ObjectBuy.drawParts do
		if buyableObjects>0 then
			nodes = nodes.."\n";
		end;
		nodes = nodes..nodeIdent..'<'..ObjectBuy.drawParts[i].buyableText..' BuyObject_Buy="'..ObjectBuy.drawParts[i].toBuy..'" BuyObject_Delete="'..ObjectBuy.drawParts[i].toDelete..'" Trigger_Buy="'..ObjectBuy.drawParts[i].toTrigger..'" Trigger_Delete="'..ObjectBuy.drawParts[i].toDeleteTrigger..'" Trans_Objects="'..ObjectBuy.drawParts[i].toTrans..'"/>';
		buyableObjects = buyableObjects+1;
	end;

    return attributes,nodes;
end;]==]

addModEventListener(ObjectBuy);
