
MBO_MasterTrigger_GUI = {}

local MBO_MasterTrigger_GUI_mt = Class(MBO_MasterTrigger_GUI);


function MBO_MasterTrigger_GUI:new()
	local self = {}
	setmetatable(self, MBO_MasterTrigger_GUI_mt);
	
	self.gui = RafftnixGUI:new(nil, true, true);
	
	self.backgroundHud = self.gui:createImage(self.gui.baseElement, 0.25, 0.01, 0.45, 1, "buyable/New1.png");
	self.backgroundClear = self.gui:createImage(self.gui.baseElement, 0.587, 0.15, 0.05, 0.03, "buyable/delete_cost.png");
	self.modName = self.gui:createImage(self.gui.baseElement, 0.36, 0.83, 0.18, 0.035, "buyable/modName.png");
	self.iconHud = self.gui:createImage(self.gui.baseElement, 0.627, 0.88, 0.07, 0.11, "buyable/icon.png");
	self.headHud = self.gui:createImage(self.gui.baseElement, 0.287, 0.855, 0.308, 0.125, "buyable/HeadHud.png");
	self.mapTitle = self.gui:createText(self.gui.baseElement, 0.26, 0.73, 0, 0, g_currentMission.missionInfo.map.title, 0.025, {0,0,0,1});
	self.headline = self.gui:createText(self.gui.baseElement, 0.33, 0.76, 0, 0, g_i18n:getText("headline"), 0.05, {0,0,0,1});
	self.masterTriggerText = self.gui:createText(self.gui.baseElement, 0.26, 0.68, 0, 0, g_i18n:getText("masterTriggerText"), 0.026, {0,0,0,1});
	self.withMBOtext = self.gui:createText(self.gui.baseElement, 0.265, 0.145, 0, 0, g_i18n:getText("MBO_with_Text"), 0.026, {0,0,0,1});
	self.withountMBO = self.gui:createText(self.gui.baseElement, 0.265, 0.065, 0, 0, g_i18n:getText("MBO_without_Text"), 0.026, {0,0,0,1});
	self.yesButton = self.gui:createImgButton(self.gui.baseElement, 0.627, 0.12, 0.045, 0.072, "buyable/yesButton.png", self.yesButtonCallback, self);
	self.noButton = self.gui:createImgButton(self.gui.baseElement, 0.627, 0.04, 0.045, 0.072, "buyable/noButton.png", self.noButtonCallback, self);

	ObjectBuy.drawPartsMaster[1].masterTriggerGUI = self;

	return self;
end;

function MBO_MasterTrigger_GUI:open()
	self.mapTitle:setTextBold(true);
	self.headline:setTextBold(true);
	self.masterTriggerText:setTextBold(true);

	self.gui:open();
end;

function MBO_MasterTrigger_GUI:close()
	self.gui:close();
end;
function MBO_MasterTrigger_GUI:yesButtonCallback()
	ObjectBuy.drawPartsMaster[1]:withoutMBO(false);
	self:close();
end;
function MBO_MasterTrigger_GUI:noButtonCallback()
	ObjectBuy.drawPartsMaster[1]:withoutMBO(true);
	self:close();
end;