﻿--
--
--
--     <Attribute name="onCreate" type="scriptCallback" value="MapBuyableObject.onCreateMaster"/>
--
--  
--		MasterTrigger for MapBuyableObjects
--
--@date: 30/08/2013
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0	release 
--			v2.0	fix MasterTriggerHud, when start a map decide with/without buyable, delete and start the map again.
--			v3.0	26/11/14	convert to Ls15
--			v3.1		14/12/14		fix Savegame load when leave the game only to mainmenu
--			v3.2		25/01/2015		create gui with rafftnixGui.lua, special thanks to Heady and rafftnix
--			v3.3		14/02/2015		add a mboListener and talk to them. Thanks to Heady
--
--
--darf in jede Map eingebaut werden, MapBuyableObject.zip darf nicht neu hochgeladen werden
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission


	print("   Map: Buyable Objects(Master) v3.3  by Bluebaby210 loaded!");

---------------------------------------
function onCreateMaster(self, id)
	--print("						created Master Trigger, id: ", id);
	local masterTrigger = MasterTriggerBuyableAll:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(masterTrigger);
    masterTrigger:load(id);
    masterTrigger:register(true);
	table.insert(ObjectBuy.drawPartsMaster, masterTrigger);
end;

MasterTriggerBuyableAll = {}
MasterTriggerBuyableAll_directory = g_currentModDirectory;
local MasterTriggerBuyableAll_mt = Class(MasterTriggerBuyableAll, Object);

function MasterTriggerBuyableAll:new(isServer, isClient)
    local self = Object:new(isServer, isClient, MasterTriggerBuyableAll_mt);
    self.className = "MasterTriggerBuyableAll";
    return self;
end;

function MasterTriggerBuyableAll:load(id)

	self.triggerId = id
	addTrigger(self.triggerId, "TriggerCallback", self);
	local x,y,z = getTranslation(self.triggerId)
	setRigidBodyType(self.triggerId, "NoRigidBody")
	setTranslation(self.triggerId, x, -1000, z)
	self.guiOpen = true;
end;

function MasterTriggerBuyableAll:delete()
	if masterTriggerAllowed ~= 0 then
		setRigidBodyType(self.triggerId, "NoRigidBody");
		local x,y,z = getTranslation(self.triggerId);
		setTranslation(self.triggerId, x, (y+1000), z);
		setRigidBodyType(self.triggerId, "Static");
		masterTriggerAllowed = 0;
	end;

	removeTrigger(self.triggerId);
end;

function MasterTriggerBuyableAll:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MasterTriggerBuyableAll:keyEvent(unicode, sym, modifier, isDown)
end;

function MasterTriggerBuyableAll:readStream(streamId, connection)
	ObjectBuy.firstRun = streamReadBool(streamId);
	masterTriggerAllowed = streamReadInt8(streamId);
end;

function MasterTriggerBuyableAll:writeStream(streamId, connection)
	streamWriteBool(streamId, ObjectBuy.firstRun);
	streamWriteInt8(streamId, masterTriggerAllowed);
end;

function MasterTriggerBuyableAll:TriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	if onEnter then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		end;
	elseif onLeave then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		end;
	end;

end;

function MasterTriggerBuyableAll:update(dt)
	if g_currentMission.paused or g_gui.currentGui ~= nil then
		return;
	end;
	if masterTriggerAllowed == 0 then
		if not ObjectBuy.firstRun then
			if g_currentMission.player ~= nil then
				if self.guiOpen then
					self.masterTriggerGUI:open();
					self.guiOpen = false;
				end;
			end;
		end;
	end;

end;

function MasterTriggerBuyableAll:saveLoad(master, firstRun, noEventSend)
	if not noEventSend then
		MasterTriggerBuyableSaveLoad.sendEvent(self, master, firstRun, noEventSend)
	end;
	masterTriggerAllowed = master;
	ObjectBuy.firstRun = firstRun;
end;

function MasterTriggerBuyableAll:withoutMBO(without, noEventSend)

	if not noEventSend then
		MasterTriggerBuyableAllEvent.sendEvent(self, without, noEventSend)
	end;
		
	if without then
		masterTriggerAllowed = 2;
		if #ObjectBuy.drawParts ~= 0 then
			for i=1, #ObjectBuy.drawParts do
				ObjectBuy.drawParts[i].hasPressedBuy = 1
				ObjectBuy.drawParts[i].infoToOthers = false;
				ObjectBuy.drawParts[i].payedPrice = true;
				ObjectBuy.drawParts[i]:visibility(true, false, 1, true);
			end;
		end;
		if #ObjectBuy.drawPartsIcon ~= 0 then
			for i=1, #ObjectBuy.drawPartsIcon do
				ObjectBuy.drawPartsIcon[i]:visibilityIcon(true, true);
			end;
		end;
	end;
		
	if not without then
		masterTriggerAllowed = 1;
	end;

end;

function MasterTriggerBuyableAll:draw()
end;


MasterTriggerBuyableAllEvent = {};
MasterTriggerBuyableAllEvent_mt = Class(MasterTriggerBuyableAllEvent, Event);

InitEventClass(MasterTriggerBuyableAllEvent, "MasterTriggerBuyableAllEvent");

function MasterTriggerBuyableAllEvent:emptyNew()
    local self = Event:new(MasterTriggerBuyableAllEvent_mt);
    self.className = "MasterTriggerBuyableAllEvent";
    return self;
end;

function MasterTriggerBuyableAllEvent:new(object, without)
    local self = MasterTriggerBuyableAllEvent:emptyNew()
    self.object = object;
	self.without = without;
    return self;
end;

function MasterTriggerBuyableAllEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.without  = streamReadBool(streamId);
    self:run(connection);
end;

function MasterTriggerBuyableAllEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.without);
end;

function MasterTriggerBuyableAllEvent:run(connection)
  self.object:withoutMBO(self.without, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MasterTriggerBuyableAllEvent:new(self.object, self.without), nil, connection, self.object);
	end;
end;

function MasterTriggerBuyableAllEvent.sendEvent(object, without, noEventSend)
  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(MasterTriggerBuyableAllEvent:new(object, without), nil, nil, object);
    else
      g_client:getServerConnection():sendEvent(MasterTriggerBuyableAllEvent:new(object, without));
    end;
  end;
end;


MasterTriggerBuyableSaveLoad = {};
MasterTriggerBuyableSaveLoad_mt = Class(MasterTriggerBuyableSaveLoad, Event);

InitEventClass(MasterTriggerBuyableSaveLoad, "MasterTriggerBuyableSaveLoad");

function MasterTriggerBuyableSaveLoad:emptyNew()
    local self = Event:new(MasterTriggerBuyableSaveLoad_mt);
    self.className = "MasterTriggerBuyableSaveLoad";
    return self;
end;

function MasterTriggerBuyableSaveLoad:new(object, master, firstRun)
    local self = MasterTriggerBuyableSaveLoad:emptyNew()
    self.object = object;
	self.master = master;
	self.firstRun = firstRun;
    return self;
end;

function MasterTriggerBuyableSaveLoad:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
	self.master = streamReadInt8(streamId);
	self.firstRun = streamReadBool(streamId);
    self:run(connection);
end;

function MasterTriggerBuyableSaveLoad:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.master);
	streamWriteBool(streamId, self.firstRun);
end;

function MasterTriggerBuyableSaveLoad:run(connection)
  self.object:saveLoad(self.master, self.firstRun, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MasterTriggerBuyableSaveLoad:new(self.object, self.master, self.firstRun), nil, connection, self.object);
	end;
end;

function MasterTriggerBuyableSaveLoad.sendEvent(object, master, firstRun, noEventSend)
  if noEventSend == nil or noEventSend == false then
    if g_server ~= nil then
      g_server:broadcastEvent(MasterTriggerBuyableSaveLoad:new(object, master, firstRun), nil, nil, object);
    else
      g_client:getServerConnection():sendEvent(MasterTriggerBuyableSaveLoad:new(object, master, firstRun));
    end;
  end;
end;