--AdditionalTrigger = {};
--
--
--to add a second or more trigger for a special buyableObject
--
--      <Attribute name="PDA_HotspotIcon" type="boolean" value="true"/>				--if the other Trigger show PDAIcon
--      <Attribute name="TextName" type="string" value="MapBuyableObject01"/>		--the textname, the same as in the buyableTrigger
--      <Attribute name="onCreate" type="scriptCallback" value="MapBuyableObject.onCreateAdditionalTrigger"/>	
--
--		you can duplicate the TG Icon_Jumping from "buyableObject" in the other trigger, remember the Icon_Ident_Object number ;)
--
--
--@date: 05/12/2014
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0	release
--			v2.0		14/12/14		fix Savegame load when leave the game only to mainmenu
--			v3.2		16/01/2015		create gui with rafftnixGui.lua for MasterTrigger
--			v3.3		14/02/2015		add a mboListener and talk to them. Thanks to Heady
--
--darf in jede Map eingebaut werden, MapBuyableObject.zip darf nicht neu hochgeladen werden
--
--Keine nderung ohne meine Erlaubnis
--No modification without my permission
--

	--print("   Map: Buyable Objects(AdditionalTrigger) v3.3 by Bluebaby210 loaded!");

function onCreateAdditionalTrigger(self, id)
	--print("created AdditionalTrigger , id: ", id);
	local another = AdditionalTrigger:new(g_server ~= nil, g_client ~= nil);
    local ati = g_currentMission:addOnCreateLoadedObject(another);
    another:load(id);
    another:register(true);
	table.insert(ObjectBuy.anotherTrigger, another);
end;

AdditionalTrigger = {}
AdditionalTrigger_directory = g_currentModDirectory;
local AdditionalTrigger_mt = Class(AdditionalTrigger, Object);

function AdditionalTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, AdditionalTrigger_mt);
    self.className = "AdditionalTrigger";
    return self;
end;

function AdditionalTrigger:load(id)
	self.triggerId = id
	addTrigger(self.triggerId, "TriggerCallback", self);

	self.textBuyable = getUserAttribute(id, "TextName");
	self.numberInMBO = 0;
	self.additionalHotspot = Utils.getNoNil(getUserAttribute(id, "PDA_HotspotIcon"), false);
	
	if #ObjectBuy.drawParts ~= 0 then
		for i=1, #ObjectBuy.drawParts do
			if ObjectBuy.drawParts[i].buyableText == self.textBuyable then
				self.numberInMBO = i;
			end;
		end;
		--
		if self.numberInMBO > 0 then
			local mbo = ObjectBuy.drawParts[self.numberInMBO];
			if self.additionalHotspot then
				if mbo.pdaIconHotspot then
					self.iconHudPDA = AdditionalTrigger_directory.."buyable/HotSpotIcon.png";
					if mbo.ownIconPDA then
						self.iconHudPDA = mbo.ownIconPath;
					end;
					if mbo.iconViewName ~= nil then
						local x,y,z = getWorldTranslation(self.triggerId);
						self.secondHotSpotBuyable = g_currentMission.ingameMap:createMapHotspot(""..mbo.iconViewName.."", Utils.getFilename(self.iconHudPDA), x, z, nil, nil, false, false, true, 0, true);
						self.secondHotSpotBuyable.fullViewName = mbo.iconViewName;
					else
						local x,y,z = getWorldTranslation(self.triggerId);
						self.secondHotSpotBuyable = g_currentMission.ingameMap:createMapHotspot(""..mbo.headlineText.."", Utils.getFilename(self.iconHudPDA), x, z, nil, nil, false, false, false, 0, true);
					end;
				end;
			else
				self.secondHotSpotBuyable = nil;
			end;
		else
			self.secondHotSpotBuyable = nil;
		end;
		--
	end;

end;

function AdditionalTrigger:delete()
	removeTrigger(self.triggerId);
end;

function AdditionalTrigger:TriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	if onEnter then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			if #ObjectBuy.drawParts ~= 0 and self.numberInMBO ~= 0 then
				local mbo = ObjectBuy.drawParts[self.numberInMBO];
				mbo.count = mbo.count + 1;
				mbo.playerInTrigger = true;
			end;
		end;
	elseif onLeave then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			if #ObjectBuy.drawParts ~= 0 and self.numberInMBO ~= 0 then
				local mbo = ObjectBuy.drawParts[self.numberInMBO];
				mbo.count = mbo.count - 1;
				mbo.playerInTrigger = false;
				if mbo.pdaState == 1 then
					g_currentMission.ingameMap.isVisible = true;
					mbo.pdaState = 0;
				end;
				if mbo.helpHudState == 1 then
					g_currentMission.showHelpText = true;
					mbo.helpHudState = 0;
				end;
			end;
		end;
	end;

end;

function AdditionalTrigger:update(dt)
end;

function AdditionalTrigger:buyed(buyableText)

	if self.additionalHotspot and self.secondHotSpotBuyable ~= nil then
		if buyableText == self.textBuyable then
				if self.secondHotSpotBuyable.fullViewName ~= nil then
					self.secondHotSpotBuyable.fullViewName = nil;
				end;
			g_currentMission.ingameMap:deleteMapHotspot(self.secondHotSpotBuyable)
		end;
	end;
end;

function AdditionalTrigger:draw()
end;