--
-- PowerShaft
-- Specialization for PowerShaft
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @date  26/07/09
--

PowerShaft = {};

function PowerShaft.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function PowerShaft:load(xmlFile)
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	self.powerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#part"));
	x,y,z = getTranslation(self.powerShaft.part);
	self.powerShaft.trans = {x,y,z};
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerShaft.part);
	local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
	self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.attacherVehiclePowerShaft = nil;
	self.doJointSearch = false;
	
	
	-- hidraulica
	self.cylinders = {};
	local i = 0;
	while true do
		local nameStr = string.format("vehicle.hydraulicCylinders.hydraulicCylinder(%d)", i);
        local cylinder = {};
        local cylinderStr = getXMLString(xmlFile, nameStr .. "#cylinder");
        if cylinderStr == nil then
            break;
        end;
        cylinder.index = Utils.indexToObject(self.components, cylinderStr);
        cylinder.directionFix = Utils.indexToObject(self.components, getXMLString(xmlFile, nameStr .. "#cylinderFix"));
		cylinder.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, nameStr .. "#punch"));
		if cylinder.punch ~= nil then
			cylinder.translationFix = Utils.indexToObject(self.components, getXMLString(xmlFile, nameStr .. "#punchFix"));
			local ax, ay, az = getWorldTranslation(cylinder.punch);
			local bx, by, bz = getWorldTranslation(cylinder.translationFix);		
			cylinder.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
		cylinder.scalePunch = Utils.getNoNil(getXMLBool(xmlFile, nameStr .. "#scale"), false);
		table.insert(self.cylinders, cylinder);
		i = i + 1;
	end;
	
	
end;

function PowerShaft:delete()
end;

function PowerShaft:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowerShaft:keyEvent(unicode, sym, modifier, isDown)
end;

function PowerShaft:update(dt)
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];	
				if joint.ptoOutput ~= nil then
					self.attacherVehiclePowerShaft = joint.ptoOutput.node;
					break;
				elseif joint.powerShaftAttacher ~= nil then
					self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
					break;
				else
					local tempRootNode = createTransformGroup("tempRootNode");
					link(joint.jointTransform, tempRootNode);
					setTranslation(tempRootNode, -0.34472, 0.23851, 0);
					setRotation(tempRootNode, 0, Utils.degToRad(-90), 0);
					self.attacherVehiclePowerShaft = tempRootNode;
					break;
				end;
			end;
		end;
		self.doJointSearch = false;
	end;
	
	--if self:getIsActive() then		
		if self.attacherVehiclePowerShaft ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerShaft.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
			local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);		
		end;		
	--end;
end;

function PowerShaft:updateTick(dt)
	for _, cylinder in pairs(self.cylinders) do
		local ax, ay, az = getWorldTranslation(cylinder.index);
		local bx, by, bz = getWorldTranslation(cylinder.directionFix);
		local x, y, z = worldDirectionToLocal(getParent(cylinder.index), bx-ax, by-ay, bz-az);
		local xU, yU, zU = 0, 1, 0;
		if math.abs(y) > 0.99 * Utils.vector3Length(x, y, z) then
			yU = 0;
			if y > 0 then
				zU = 1;
			else
				zU = -1;
			end;
		end;
		setDirection(cylinder.index, x, y, z, xU, yU, zU);
		if cylinder.punchDistance ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			if cylinder.scalePunch then
				local xS, yS, zS = getScale(cylinder.punch);
				local newS = xS * (distance / cylinder.punchDistance);
				setScale(cylinder.punch, xS, yS, newS);
			else
				setTranslation(cylinder.punch, 0, 0, distance-cylinder.punchDistance);
			end;
		end;
	end;
end

function PowerShaft:draw()
end;

function PowerShaft:onAttach(attacherVehicle)
	self.doJointSearch = true;
end;

function PowerShaft:onDetach()
	setTranslation(self.powerShaft.part, unpack(self.powerShaft.trans));
	setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
end;