--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.82, 0.20, 0.015, "Klawisz Numpad 0: Info");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.82, 0.20, 0.015, "Klawisz Numpad 0: Info ");
		renderText(0.77, 0.86, 0.02, "- URSUS C-360 -");
		renderText(0.72, 0.83, 0.018, "Klawisz Numpad 4: Lusterko Lewe");			
		renderText(0.72, 0.81, 0.018, "Klawisz Numpad 5: Dach");
		renderText(0.72, 0.79, 0.018, "Klawisz Numpad 6: Lusterko Prawe");
		renderText(0.72, 0.77, 0.018, "Klawisz Numpad 8: Halogen Przd");				
		renderText(0.72, 0.71, 0.018, "");
		renderText(0.72, 0.69, 0.018, "- Created by CatFan18 -");
              	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




