SetToggleGridEvent = {};
SetToggleGridEvent_mt = Class(SetToggleGridEvent, Event);

InitEventClass(SetToggleGridEvent, "SetToggleGridEvent");

function SetToggleGridEvent:emptyNew()
    local self = Event:new(SetToggleGridEvent_mt);
    self.className="SetToggleGridEvent";
    return self;
end;

function SetToggleGridEvent:new(vehicle, gridState)
    local self = SetToggleGridEvent:emptyNew()
    self.vehicle = vehicle;
	self.gridState = gridState;
    return self;
end;

function SetToggleGridEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.gridState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetToggleGridEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.gridState);
end;

function SetToggleGridEvent:run(connection)   
	self.vehicle:setToggleGrid(self.gridState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetToggleGridEvent:new(self.vehicle, self.gridState), nil, connection, self.vehicle);
    end;
end;

function SetToggleGridEvent.sendEvent(vehicle, gridState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetToggleGridEvent:new(vehicle, gridState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetToggleGridEvent:new(vehicle, gridState));
		end;
	end;
end;