SetRightDoorEvent = {};
SetRightDoorEvent_mt = Class(SetRightDoorEvent, Event);

InitEventClass(SetRightDoorEvent, "SetRightDoorEvent");

function SetRightDoorEvent:emptyNew()
    local self = Event:new(SetRightDoorEvent_mt);
    self.className="SetRightDoorEvent";
    return self;
end;

function SetRightDoorEvent:new(vehicle, rightDoorState)
    local self = SetRightDoorEvent:emptyNew()
    self.vehicle = vehicle;
	self.rightDoorState = rightDoorState;
    return self;
end;

function SetRightDoorEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.rightDoorState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRightDoorEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.rightDoorState);
end;

function SetRightDoorEvent:run(connection)   
	self.vehicle:toggleRightDoor(self.rightDoorState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRightDoorEvent:new(self.vehicle, self.rightDoorState), nil, connection, self.vehicle);
    end;
end;

function SetRightDoorEvent.sendEvent(vehicle, rightDoorState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRightDoorEvent:new(vehicle, rightDoorState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRightDoorEvent:new(vehicle, rightDoorState));
		end;
	end;
end;