--
-- EnterAnimation
-- Specialization for Enter Animation
--
-- @author  JoXXer
-- @date  21/09/11
--

-- Edit: Rockstar94

EnterAnimation = {};

function EnterAnimation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function EnterAnimation:load(xmlFile)
	self.skipAnimation = SpecializationUtil.callSpecializationsFunction("skipAnimation");

	self.onEnterAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.onEnter#rootNode"));
    self.onEnterAnimCharSet = 0;
    if self.onEnterAnimRootNode ~= nil and self.onEnterAnimRootNode ~= 0 then
        self.onEnterAnimCharSet = getAnimCharacterSet(self.onEnterAnimRootNode);
        if self.onEnterAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.onEnterAnimCharSet, getXMLString(xmlFile, "vehicle.onEnter#clip"));
            assignAnimTrackClip(self.onEnterAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.onEnterAnimCharSet, 0, false);
            local onEnterAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.onEnter#speedScale"), 1);
			setAnimTrackSpeedScale(self.onEnterAnimCharSet, 0, onEnterAnimSpeedScale);
            self.onEnterAnimDuration = getAnimClipDuration(self.onEnterAnimCharSet, clip);
        end;
    end;

	self.hasPlayedOnEnter = true;
	self.hasEntered = false;
	
	self.armNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#armIndex"));
end;

function EnterAnimation:delete()
end;

function EnterAnimation:readStream(streamId, connection)

end;

function EnterAnimation:writeStream(streamId, connection)

end;

function EnterAnimation:readUpdateStream(streamId, timestamp, connection)

end;

function EnterAnimation:writeUpdateStream(streamId, connection, dirtyMask)

end;

function EnterAnimation:mouseEvent(posX, posY, isDown, isUp, button)

end;

function EnterAnimation:keyEvent(unicode, sym, modifier, isDown)
end;

function EnterAnimation:update(dt)
	if self.camIndex == 1 then
		setVisibility(self.armNode, true);
	else
		setVisibility(self.armNode, false);
	end;
	
	if not self.isEntered then
		setVisibility(self.armNode, false);
	end;

	if self.hasPlayedOnEnter == false then
		self:setAnimationTime(4, self.animationParts[4].animDuration);
		self.sound3 = false;
		self.sound4 = true;
		setVisibility(self.armNode, false);	
		if self.animationParts[4].clipEndTime then
			if self.onEnterAnimCharSet ~= 0 then
				if getAnimTrackTime(self.onEnterAnimCharSet, 0) < 0.0 then
					setAnimTrackTime(self.onEnterAnimCharSet, 0, 0.0);
				end;
				setAnimTrackSpeedScale(self.onEnterAnimCharSet, 0, 1);
				enableAnimTrack(self.onEnterAnimCharSet, 0);
			end;
		end;

		if getAnimTrackTime(self.onEnterAnimCharSet, 0) > self.onEnterAnimDuration then
			self:setAnimationTime(4, self.animationParts[4].offSet);	
			self.sound3 = true;
			self.sound4 = false;
			self.hasEntered = true;
			setVisibility(self.armNode, true);	
		end;
		
		if self.hasEntered then
			self.hasPlayedOnEnter = true;
		end;
		if InputBinding.hasEvent(InputBinding.SKIP_ENTER_ANIMATION_c360) then
			self:skipAnimation();
		end;
	end;
end;

function EnterAnimation:updateTick(dt)
end;

function EnterAnimation:draw()
	if not self.hasPlayedOnEnter then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("SKIP_ENTER_ANIMATION"), self.typeDesc), InputBinding.SKIP_ENTER_ANIMATION_c360);
	end;
end;

function EnterAnimation:skipAnimation()
	self.hasEntered = true;
	disableAnimTrack(self.onEnterAnimCharSet, 0);
	setAnimTrackTime(self.onEnterAnimCharSet, 0, 8500.0);
	setTranslation(self.onEnterAnimRootNode, 0, 1.536, 0.275);
	setRotation(self.onEnterAnimRootNode, math.rad(0), math.rad(0), math.rad(0));
end;

function EnterAnimation:onLeave()
	self.hasEntered = false;
	self.hasPlayedOnEnter = true;	
	disableAnimTrack(self.onEnterAnimCharSet, 0);
	setAnimTrackTime(self.onEnterAnimCharSet, 0, 0.0);
	setTranslation(self.onEnterAnimRootNode, 1.709, 0.855, 1.026);
	setRotation(self.onEnterAnimRootNode, math.rad(180), math.rad(-80), math.rad(180));
end;

function EnterAnimation:onEnter()
	self.hasPlayedOnEnter = false;
end;
