--Specjalizacja--
--Hydraulika--
--by--
--siudix29--


Hydraulika = {};


function Hydraulika.prerequisitesPresent(specializations)
   return true;
end;

function Hydraulika:load(xmlFile)
    local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);
    self.hydraulics = {};
    for i=1, hydraulicsCount do
        local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);
        self.hydraulics[i] = {};
        self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
        self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
        self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
        self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
        local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
        self.hydraulics[i].upVectors = {xUp, yUp, zUp};
 
        local ax, ay, az;
        if self.hydraulics[i].punch ~= nil then
            ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
        else
            ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
        end;
        if self.hydraulics[i].translationPunch ~= nil then
            local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);
            self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
        end;
	end;
    self.setHydraulicTime = 30;
    self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
    self.otworz = false
    self.zamknij = false
    
    local rotationLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Lifter#index"));
	self.Lifter = {};
	self.Lifter.node = rotationLifter;

	local rotationLifterArm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterArm#index"));
	self.LifterArm = {};
	self.LifterArm.node = rotationLifterArm;

	local rotationLifterBottom = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterBottom#index"));
	self.bottomArm2 = {};
	self.bottomArm2.node = rotationLifterBottom;

	local BottomArmNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.bottomArm#rotationNode"));
	self.bottomArm = {};
	self.bottomArm.node = BottomArmNode;
end;

 function Hydraulika:delete()
end;

function Hydraulika:keyEvent(unicode, sym, modifier, isDown)
 end;

function Hydraulika:update(dt)

    if self:getIsActive() then
        self.setHydraulicTime = 30;
    end;
		
	if self.setHydraulicTime > 0 then
        for k,v in pairs(self.hydraulics) do
        self:setHydraulicDirection(k);
        end;
        self.setHydraulicTime = self.setHydraulicTime - 1;
    end;
    if self.Lifter.node ~= nil and self.bottomArm2.node ~= nil then
            rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
            setRotation(self.Lifter.node, rBBArmX*2, 0, 0);
    end;
    if self.LifterArm.node ~= nil and self.bottomArm2.node ~= nil then
            setRotation(self.LifterArm.node, 0.05-rBBArmX*2, 0, 0);
    end;
end;

function Hydraulika:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hydraulika:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function Hydraulika:draw()
end;
function Hydraulika:setHydraulicDirection(index)
    local hydraulic = self.hydraulics[index];
 
    if hydraulic.fixPoint ~= nil then
        local ax, ay, az = getWorldTranslation(hydraulic.node);
        local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
        local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
        local xUp, yUp, zUp = unpack(hydraulic.upVectors);
        setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
        if hydraulic.punch ~= nil then
            local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
            setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
        end;
    end;
end;
function Hydraulika:updateTick(dt)
		if self.backHydraulic ~= nil then		
		local x, y, z = getRotation(self.attacherJoints[1].bottomArm.rotationNode);
		setRotation(self.backHydraulic.rootArm, x, y, z);	
	end;		
end;