--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.82, 0.29, 0.015, "Klawisz Numpad 0: Info");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.82, 0.29, 0.015, "Klawisz Numpad 0: Info ");
		renderText(0.77, 0.83, 0.02, "- URSUS 914 -");
		renderText(0.72, 0.81, 0.018, "Klawisz Numpad 9: drzwi prawe");			
		renderText(0.72, 0.79, 0.018, "Klawisz Numpad 7: drzwi lewe");
		renderText(0.72, 0.77, 0.018, "Klawisz Numpad 8: dach");
		renderText(0.72, 0.73, 0.018, "Klawisz Numpad 4: szyba tyl");				
		renderText(0.72, 0.71, 0.018, "Klawisz Numpad 6: halogen tylny");
		renderText(0.72, 0.69, 0.018, "Klawisz Numpad 5: halogen przedni");
		renderText(0.72, 0.67, 0.018, "Klawisz Numpad 1: kierunek lewy");
		renderText(0.72, 0.65, 0.018, "Klawisz Numpad 2: awaryjne");
		renderText(0.72, 0.61, 0.018, "Klawisz Numpad 3: kierunek prawy");
		renderText(0.72, 0.59, 0.018, "Klawisz Key    6: konsola");
		renderText(0.72, 0.57, 0.018, "");
		renderText(0.72, 0.55, 0.018, "- Created by pawlo101299 -");
              	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




