--
-- reels
-- author: werik
--

reels = {};

function reels.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function reels:load(xmlFile)
	self.reels = {};
              self.reels.speed = 0;
	self.reels.speedScaleTime = 5000;
	self.reels.speedScaleBackup = self.reelSpeedScale;
	self.reels.rollSpeedBackup = self.rollNodes[1].speed;
	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;
end;

function reels:readStream(streamId, connection)
end;

function reels:writeStream(streamId, connection)
end;

function reels:delete()
end;

 
function reels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function reels:keyEvent(unicode, sym, modifier, isDown)

end;
 
function reels:update(dt)
	if self:getIsActive() and self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.reels.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.reels.speedScaleBackup * percent}, {0}, 1, self.reels.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.reels.rollSpeedBackup * percent}, {0}, 1, self.reels.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.reels.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.reels.speedScaleBackup * percent}, {0}, 1, self.reels.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.reels.rollSpeedBackup * percent}, {0}, 1, self.reels.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
	end;
end;

function reels:onLeave()
end;

function reels:draw()
end;
