--
-- Teleskoplader
--
-- M@D Author  Headshot XXL
-- M@D date  29.04.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --


Teleskoplader = {}

function Teleskoplader.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Teleskoplader:load(xmlFile)        
	
	local rotationNode8 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation8#index"));
    if rotationNode8 ~= nil then
        self.rotation8 = {};
        self.rotation8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#minRot"));
        self.rotation8.minRot = {};
        self.rotation8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#maxRot"));
        self.rotation8.maxRot = {};
        self.rotation8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#rotTime"), 2)*1000;
        self.rotation8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#touchRotLimit"), 10));
    end;
	
	local rotationNode9 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation9#index"));
    if rotationNode9 ~= nil then
        self.rotation9 = {};
        self.rotation9.node = rotationNode9;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#minRot"));
        self.rotation9.minRot = {};
        self.rotation9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation9#maxRot"));
        self.rotation9.maxRot = {};
        self.rotation9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation9#rotTime"), 2)*1000;
        self.rotation9.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation9#touchRotLimit"), 10));
    end;

end;
      
function Teleskoplader:delete()    
end;

function Teleskoplader:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Teleskoplader:keyEvent(unicode, sym, modifier, isDown)

	if sym == Input.KEY_n then
		self.rotation9Max = isDown;
	end;
	if sym == Input.KEY_m then
		self.rotation9Min = isDown;
	end;
	if sym == Input.KEY_n then
		self.rotation8Max = isDown;
	end;
	if sym == Input.KEY_m then
		self.rotation8Min = isDown;
	end;

end;

function Teleskoplader:update(dt)
	
	local doRotate = self.rotation8Max or self.rotation8Min 
	if self.rotation8 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation8.maxRot, self.rotation8.minRot, 3, self.rotation8.rotTime, dt, not self.rotation8Max);
        setRotation(self.rotation8.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation9Max or self.rotation9Min 
	if self.rotation9 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation9.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation9.maxRot, self.rotation9.minRot, 3, self.rotation9.rotTime, dt, not self.rotation9Max);
        setRotation(self.rotation9.node, unpack(newRot));
    end;

end;

function Teleskoplader:draw()
end;

function Teleskoplader:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
