--
-- OilPallet
-- Specialization for Oil change
--
-- @author  	JoXXer
-- @version 	v1.0
-- @date  		16/11/11
-- @history:	v1.0 - Initial version
--

OilPallet = {};

function OilPallet.prerequisitesPresent(specializations)
    return true;
end;

function OilPallet:load(xmlFile)

	self.changeOil = SpecializationUtil.callSpecializationsFunction("changeOil");

	self.oilPalletTriggerCallback = OilPallet.oilPalletTriggerCallback;

	self.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.oilPallet#checkString"), "OilChange")
	self.usingTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oilPallet#activationTrigger"));
	local oilCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.oilPallet#capacity"),60);
	self.oilCapacity = oilCapacity;
	self.oilDefaultCapacity = oilCapacity;
	local cans = getXMLString(xmlFile, "vehicle.oilPallet#cans");
	self.cans = {};
	if cans ~= nil then
		local canObject = Utils.indexToObject(self.components, cans);
		if canObject ~= nil then
			local num = getNumOfChildren(canObject);
			for i=0, num-1 do
				local child = getChildAt(canObject, i);
				if child ~= nil then
					table.insert(self.cans, child);
				end;
			end;
		end;
	end;
	self.canCount = table.getn(self.cans);
	self.lastCapacity = 0;

	addTrigger(self.usingTrigger, "oilPalletTriggerCallback", self);
	-- self.deleteListenerId = addDeleteListener(self.usingTrigger, "oilDelete", self); --

	self.oilPalletVehicle = 1;
end;

function OilPallet:delete()
    removeTrigger(self.usingTrigger);
end;

function OilPallet:wheelDelete()
    removeDeleteListener(self.usingTrigger, self.deleteListenerId);
end;

function OilPallet:readStream(streamId, connection)
	self.oilCapacity = streamReadFloat32(streamId);
end;

function OilPallet:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.oilCapacity);
end;

function OilPallet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OilPallet:keyEvent(unicode, sym, modifier, isDown)
end;

function OilPallet:update(dt)
end;

function OilPallet:updateTick(dt)
	if self.lastCapacity ~= self.oilCapacity then
		if self.canCount ~= nil and self.canCount > 0 then
			local oilPerCan = self.oilDefaultCapacity / self.canCount;
			local oilLeft = oilPerCan;
			local capCheck = self.oilCapacity + oilPerCan;
			for i=1, table.getn(self.cans) do
				if capCheck > oilLeft then
					if not getVisibility(self.cans[i]) then
						setVisibility(self.cans[i], true);
					end;
				else
					if getVisibility(self.cans[i]) then
						setVisibility(self.cans[i], false);
					end;
				end;
				oilLeft = oilLeft + oilPerCan;
			end;
		end;
		self.lastCapacity = self.oilCapacity;
	end;
end;

function OilPallet:draw()
end;

function OilPallet:oilPalletTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if otherId == otherShapeId then
		local vehicle = g_currentMission.nodeToVehicle[otherId];
		if vehicle ~= nil then
			if onEnter then
				if vehicle.oilChange ~= nil then
					if vehicle.oilChange.checkString == self.checkString then
						vehicle.oilChange.oilInRange = self;
					end;
				end;
			elseif onLeave then
				if vehicle.oilChange ~= nil then
					vehicle.oilChange.oilInRange = nil;
				end;
			end;
		end;
	end;
end;

function OilPallet:changeOil(vehicle, noEventSend)
	OilChangeEvent.sendEvent(self, vehicle, noEventSend);
	if vehicle.oilChange ~= nil then
		vehicle:changeOil(self);
	end;
end;

function OilPallet:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueInt = getXMLFloat(xmlFile, key.."#oilCapacity");
		if valueInt ~= nil then
			self.oilCapacity = valueInt;
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function OilPallet:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;
	attributes = 'oilCapacity="'.. self.oilCapacity .. '"';
	return attributes, nil;
end;




