--
-- startParticleSystems
-- Specialization for startParticleSystems
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--

startParticleSystems = {};

function startParticleSystems.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function startParticleSystems:load(xmlFile)

local rotationPartNodeKmh1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
self.startThreshingExhaustParticleSystems = {};
	local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.startThreshingExhaustParticleSystems#count"), 0);
	for i=1, exhaustParticleSystemCount do
		local namei = string.format("vehicle.startThreshingExhaustParticleSystems.startThreshingExhaustParticleSystem%d", i);
		Utils.loadParticleSystem(xmlFile, self.startThreshingExhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
	end;
end;

function startParticleSystems:delete()
Utils.deleteParticleSystem(self.startThreshingExhaustParticleSystems);
end;

function startParticleSystems:readStream(streamId, connection)
end;

function startParticleSystems:writeStream(streamId, connection)
end;

function startParticleSystems:mouseEvent(posX, posY, isDown, isUp, button)
end;

function startParticleSystems:keyEvent(unicode, sym, modifier, isDown)
end;

function startParticleSystems:update(dt)
local psEnableTimeStartDelay = 100;
	local psDuration = 1000;
	local psEnableTime = (self.motorStartTime - self.motorStartDuration) + psEnableTimeStartDelay;
	local psDisableTime = psEnableTime + psDuration;
	
	if self.isClient then
		if (g_currentMission.time <= psDisableTime and g_currentMission.time >= psEnableTime  and self.isMotorStarted) then
			Utils.setEmittingState(self.startThreshingExhaustParticleSystems, true);
		else
			Utils.setEmittingState(self.startThreshingExhaustParticleSystems, false);
		end;
	end;
end;

function startParticleSystems:updateTick(dt)
end;

function startParticleSystems:draw()
end;

-- function startParticleSystems:validateAttacherJoint(implement, jointDesc, dt)
    -- return true;
-- end;
