Teleportation = {};
Teleportation.modDir = g_currentModDirectory;
local pallet;
function Teleportation:loadMap(name)
	self.mapMarkerHUD = createImageOverlay(Teleportation.modDir.."MapMarker.dds");
	self.active = false;
	self.IDs = {};
	self.currentId = 1;
	self.mousePos = {0.5, 0.5};
	self.hudsState = {};
	self.timer = 0;
end;
function Teleportation:deleteMap()
end;
function Teleportation:mouseEvent(posX, posY, isDown, isUp, button)
	if self.active then
		if isDown and button == 1 then
			local x,z;
			local mapSize = g_currentMission.terrainSize;
			if posX <= 0.5 then x = -(0.5 - posX)*mapSize; else x = (posX - 0.5)*mapSize; end;
			if posY <= 0.5 then z = (0.5 - posY)*mapSize; else z = -(posY - 0.5)*mapSize; end;
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z)+1;
			if Input.isKeyPressed(Input.KEY_lshift) then terrainHeight = terrainHeight + 25; end;
			local vehicle = g_currentMission.nodeToVehicle[self.IDs[math.floor(self.currentId)]];
			if vehicle ~= nil then
				if vehicle.isEntered then
					self.vehicleId = vehicle.rootNode;
					g_currentMission:onLeaveVehicle();
				end;
				local vehicles = {vehicle};
				local tempRootNode = createTransformGroup("tempRootNode");
				if vehicle.attachedImplements ~= nil then
					for i=1, #vehicle.attachedImplements do
						table.insert(vehicles, vehicle.attachedImplements[i].object);
						if vehicle.attachedImplements[i].object.attachedImplements ~= nil then
							for k=table.getn(vehicle.attachedImplements[i].object.attachedImplements), 1, -1 do
								vehicle.attachedImplements[i].object:detachImplement(1, true);
							end;
						end;
					end;
					for k=1, #vehicles do
						for i=1, #vehicles[k].components do
							link(tempRootNode, vehicles[k].components[i].node);
						end;
					end;
						local wx, wy, wz = getWorldTranslation(vehicle.rootNode);
						x=x-wx; z=z-wz;
						setTranslation(tempRootNode, x, terrainHeight-wy, z);
					for k=1, #vehicles do
						for i=1, #vehicles[k].components do
							local x,y,z = getWorldTranslation(vehicles[k].components[i].node);
							setTranslation(vehicles[k].components[i].node, x,y,z);
							link(getRootNode(), vehicles[k].components[i].node);
						end;
					end;
					delete(tempRootNode);
				else
					vehicle:setRelativePosition(x, 1, z, 0);
				end;
			else
				setTranslation(self.IDs[math.floor(self.currentId)], x, terrainHeight, z);
			end;
			self.active = false;
			Teleportation:forExit()
		end;
		if button == Input.MOUSE_BUTTON_WHEEL_UP then
			self.currentId = math.max(self.currentId - 0.5, 1);
		elseif button == Input.MOUSE_BUTTON_WHEEL_DOWN then
			self.currentId = math.min(self.currentId + 0.5, #self.IDs);
		end;
		self.mousePos[1] = posX;
		self.mousePos[2] = posY;
	end;
end;
function Teleportation:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_t then
		self.active = not self.active;
		if self.active then
			self.mapHUD = createImageOverlay(Utils.getFilename(g_currentMission.ingameMap.mapOverlay.filename));
			InputBinding.setShowMouseCursor(true);
			self.IDs[1] = g_currentMission.player.rootNode;
			for k, vehicle in pairs(g_currentMission.vehicles) do
				if vehicle.attacherVehicle == nil then
					table.insert(self.IDs, vehicle.rootNode);
					if vehicle.isEntered then
						self.currentId = #self.IDs;
					end;
				end;
			end;
			self.hudsState[1] = g_currentMission.renderTime;
			self.hudsState[2] = g_currentMission.showHelpText;
			self.hudsState[3] = g_currentMission.showHudEnv;
			self.hudsState[4] = g_currentMission.showWeatherForecast;
			self.hudsState[6] = g_currentMission.showVehicleInfo;
			self.hudsState[7] = g_currentMission.showVehicleSchema;
			g_currentMission.renderTime = false;
			g_currentMission.showHelpText = false;
			g_currentMission.showHudEnv  = false;
			g_currentMission.showWeatherForecast = false;
			g_currentMission.showVehicleInfo = false;
			g_currentMission.showVehicleSchema = false;
		else
			Teleportation:forExit()
		end;
	end;
end;

function Teleportation:forExit()
	InputBinding.setShowMouseCursor(false);
	self.IDs = {};
	g_currentMission.renderTime = self.hudsState[1];
	g_currentMission.showHelpText = self.hudsState[2];
	g_currentMission.showHudEnv  = self.hudsState[3];
	g_currentMission.showWeatherForecast = self.hudsState[4];
	g_currentMission.showVehicleInfo = self.hudsState[6];
	g_currentMission.showVehicleSchema = self.hudsState[7];
end;

function Teleportation:update(dt)
	if self.vehicleId then
		self.timer = math.min(self.timer+1, 15);
		if self.timer == 15 then
			g_currentMission:onEnterVehicle(g_currentMission.nodeToVehicle[self.vehicleId]);
			self.vehicleId = nil;
			self.timer = 0;
		end;
	end;
end;
function Teleportation:draw(dt)
	if self.active then
		renderOverlay(self.mapHUD, 0, 0, 1, 1);
		local px = 0.01;
		local py = 0.005;
		local name;
		if self.IDs[math.floor(self.currentId)] == g_currentMission.player.rootNode then
			name = "player";
		else
			local vehicle = g_currentMission.nodeToVehicle[self.IDs[math.floor(self.currentId)]];
			local VCFN = string.lower(vehicle.configFileName);
			local StoreItem = StoreItemsUtil.storeItemsByXMLFilename[VCFN];
			local storeImage = createImageOverlay(Utils.getFilename(StoreItem.imageActive));
			local y = 0.7;
			if self.mousePos[2] > 0.5 then y = 0.1; end;
			if storeImage > 0 then renderOverlay(storeImage, 0.1, y, 0.14, 0.14); end;
			name = StoreItem.name;
			if vehicle.attachedImplements ~= nil then
				for i=1, table.getn(vehicle.attachedImplements) do
					local VCFN = string.lower(vehicle.attachedImplements[i].object.configFileName);
					local StoreItem = StoreItemsUtil.storeItemsByXMLFilename[VCFN];
					local storeImage = createImageOverlay(Utils.getFilename(StoreItem.imageActive));
					local y = 0.7;
					if self.mousePos[2] > 0.5 then y = 0.1; end;
					if storeImage > 0 then renderOverlay(storeImage, 0.1+0.16*i, y, 0.14, 0.14); end;
					name = name.." + "..StoreItem.name;
				end;
			end;
		end;
		if self.mousePos[1] > 0.5 then px = -(string.len(name)*0.005)-0.03; end;
		if self.mousePos[2] > 0.5 then py = -0.04; end;
		renderText(self.mousePos[1]+px, self.mousePos[2]+py, 0.020, name);
		local x, _, z = getWorldTranslation(self.IDs[math.floor(self.currentId)]);
		local mapSize = g_currentMission.terrainSize;
		x = 0.5 + x/mapSize;
		z =-(z/mapSize - 0.5);
		renderOverlay(self.mapMarkerHUD, x-0.025, z, 0.05, 0.05);
	end;
end;
addModEventListener(Teleportation);
