
gasTankPlaceable = {};
gasTankPlaceable_mt = Class(gasTankPlaceable, Placeable);
InitObjectClass(gasTankPlaceable, "gasTankPlaceable");

function gasTankPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, gasTankPlaceable_mt);
    registerObjectClassName(self, "gasTankPlaceable");
    return self;
end;

function gasTankPlaceable:delete()
    removeTrigger(self.GasTriggerId);
    unregisterObjectClassName(self);
    gasTankPlaceable:superClass().delete(self);
end;

function gasTankPlaceable:deleteFinal()
    gasTankPlaceable:superClass().deleteFinal(self);
end;

function gasTankPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not gasTankPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.GasTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.GasTrigger#index"));
    GasStation:onCreate(self.GasTriggerId);
    delete(xmlFile);
    return true;
end;

function gasTankPlaceable:update(dt)
end;
registerPlaceableType("gasTankPlaceable", gasTankPlaceable);