--
-- PortaEsquerda
--
-- @Hugo94Fr
-- @23/09/2015

PortaEsquerda = {};

PortaEsquerda.modDir = g_currentModDirectory;

function PortaEsquerda.prerequisitesPresent(specializations)
    return true; 
end;

function PortaEsquerda:load(xmlFile)

	self.AnimacaoPortaEsquerda = SpecializationUtil.callSpecializationsFunction("AnimacaoPortaEsquerda"); 
	
	self.Porta = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("vehicle.PortaEsquerda#trigger")) );
	if trigger == nil then
		print("[Error::PortaEsquerda] Falta dizer onde se encontra o Trigger no XML."..tostring(i+1).." no seu vehicle.xml");
	end;
	
	local PortaES = getXMLInt(xmlFile, string.format("vehicle.PortaEsquerda#PortaES", i));
	
	self.Porta.PortaES = PortaES;
	self.Porta.trigger = trigger;
	self.Porta.TMP = false;
		
	addTrigger( trigger, "AnimacaoPortaEsquerda", self );				
	
end;

function PortaEsquerda:delete()
	if self.Porta.trigger ~= nil then
		removeTrigger(self.Porta.trigger);
	end;
end;

function PortaEsquerda:readStream(streamId, connection)
end;

function PortaEsquerda:writeStream(streamId, connection)
end;

function PortaEsquerda:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PortaEsquerda:keyEvent(unicode, sym, modifier, isDown)
end;

function PortaEsquerda:update(dt)
	
	if self.Porta.TMP then
		g_currentMission:addHelpButtonText( g_i18n:getText("PortaEsquerda"), InputBinding.PortaEsquerda );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_CENTER); 				
		renderText( 0.5, 0.06, 0.05, g_i18n:getText("PortaEsquerda") );
		if InputBinding.hasEvent(InputBinding.PortaEsquerda)then
			local obj = self.interactiveObjects[self.Porta.PortaES];
			if obj ~= nil then
				self:doActionOnObject(self.Porta.PortaES);
			end;
		end
	end;
end;

function PortaEsquerda:onLeave()
end;

function PortaEsquerda:draw()
end;

function PortaEsquerda:AnimacaoPortaEsquerda(triggerId, otherId, onEnter, onLeave, onStay)
	
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.Porta.TMP = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.Porta.TMP = false;
	end;
	
end;

