--
-- PortaDireita
--
-- @Hugo94Fr
-- @23/09/2015

PortaDireita = {};

PortaDireita.modDir = g_currentModDirectory;

function PortaDireita.prerequisitesPresent(specializations)
    return true; 
end;

function PortaDireita:load(xmlFile)

	self.AnimacaoPortaDireita = SpecializationUtil.callSpecializationsFunction("AnimacaoPortaDireita"); 
	
	self.PortaE = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("vehicle.PortaDireita#trigger")) );
	if trigger == nil then
		print("[Error::PortaDireita] Falta dizer onde se encontra o Trigger no XML."..tostring(i+1).." no seu vehicle.xml");
	end;
	
	local PortaD = getXMLInt(xmlFile, string.format("vehicle.PortaDireita#PortaD", i));
	
	self.PortaE.PortaD = PortaD;
	self.PortaE.trigger = trigger;
	self.PortaE.TMP = false;
		
	addTrigger( trigger, "AnimacaoPortaDireita", self );				
	
end;

function PortaDireita:delete()
	if self.PortaE.trigger ~= nil then
		removeTrigger(self.PortaE.trigger);
	end;
end;

function PortaDireita:readStream(streamId, connection)
end;

function PortaDireita:writeStream(streamId, connection)
end;

function PortaDireita:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PortaDireita:keyEvent(unicode, sym, modifier, isDown)
end;

function PortaDireita:update(dt)
	
	if self.PortaE.TMP then
		g_currentMission:addHelpButtonText( g_i18n:getText("PortaDireita"), InputBinding.PortaDireita );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_CENTER); 				
		renderText( 0.5, 0.06, 0.05, g_i18n:getText("PortaDireita") );
		if InputBinding.hasEvent(InputBinding.PortaDireita)then
			local obj = self.interactiveObjects[self.PortaE.PortaD];
			if obj ~= nil then
				self:doActionOnObject(self.PortaE.PortaD);
			end;
		end
	end;
end;

function PortaDireita:onLeave()
end;

function PortaDireita:draw()
end;

function PortaDireita:AnimacaoPortaDireita(triggerId, otherId, onEnter, onLeave, onStay)
	
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.PortaE.TMP = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.PortaE.TMP = false;
	end;
	
end;

