--
-- Lua DesaparecimentoFarmer
--
-- @author: Hugo94Fr
-- @date: 13/09/2015
-- @time: 23h12

DesaparecimentoFarmer = {};

function DesaparecimentoFarmer.prerequisitesPresent(specializations)
	return true;
end;

function DesaparecimentoFarmer:load(xmlFile)
	self.Farmer = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#DesaparecimentoFarmer"));
end;

function DesaparecimentoFarmer:postLoad(xmlFile)
	if self.Farmer ~= nil then
		setVisibility(self.Farmer, false);
	end;
end;

function DesaparecimentoFarmer:delete()
end;

function DesaparecimentoFarmer:readStream(streamId, connection)
end;

function DesaparecimentoFarmer:writeStream(streamId, connection)
end;

function DesaparecimentoFarmer:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
end;

function DesaparecimentoFarmer:getSaveAttributesAndNodes(nodeIdent)
end;

function DesaparecimentoFarmer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DesaparecimentoFarmer:keyEvent(unicode, sym, modifier, isDown)
end;

function DesaparecimentoFarmer:update(dt)
end;

function DesaparecimentoFarmer:updateTick(dt)
end;

function DesaparecimentoFarmer:draw()
end;

function DesaparecimentoFarmer:onEnter()
	if self.Farmer ~= nil then
		setVisibility(self.Farmer, true);
	end;
end;

function DesaparecimentoFarmer:onLeave()
	if self.Farmer ~= nil then
		if self.disableCharacterOnLeave then
			setVisibility(self.Farmer, false);
		else
			setVisibility(self.Farmer, true);
		end;
	end;
end;
