-- author: rafftnix
-- date: 30.06.2015

-- note: rafftnixGUI needed!!

CameradeTrabalho1 = {};

function CameradeTrabalho1.prerequisitesPresent(specializations)
    return RafftnixGUI ~= nil;
end;

function CameradeTrabalho1:load(xmlFile)
	self.gui = RafftnixGUI:new(nil, false, false);

	local posX = getXMLFloat(xmlFile, "vehicle.CameradeTrabalho1.backGround#x");
	local posY = getXMLFloat(xmlFile, "vehicle.CameradeTrabalho1.backGround#y");
	local width = getXMLFloat(xmlFile, "vehicle.CameradeTrabalho1.backGround#width");
	local height = getXMLFloat(xmlFile, "vehicle.CameradeTrabalho1.backGround#height");
	local fileName = getXMLString(xmlFile, "vehicle.CameradeTrabalho1.backGround#fileName");
	self.gui:createImage(self.gui.baseElement, posX, posY, width, height, fileName);

	local cameraId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.CameradeTrabalho1#index"));
	local posX = getXMLFloat(xmlFile, "vehicle.CameradeTrabalho1.position#x");
	local posY = getXMLFloat(xmlFile, "vehicle.CameradeTrabalho1.position#y");
	local width = getXMLFloat(xmlFile, "vehicle.CameradeTrabalho1.position#width");
	local height = getXMLFloat(xmlFile, "vehicle.CameradeTrabalho1.position#height");
	self.gui:createRenderOverlay(self.gui.baseElement, posX, posY, width, height, cameraId, 512, 512, getScreenAspectRatio());
end;

function CameradeTrabalho1:delete()
  
end;

function CameradeTrabalho1:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CameradeTrabalho1:keyEvent(unicode, sym, modifier, isDown)
end;

function CameradeTrabalho1:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.CameradeTrabalho1) then
			local visibility = self.gui.baseElement.visibility;
			visibility = not visibility;
			if visibility then
				self.gui:open();
			else
				self.gui:close();
			end;
		end;
	elseif self.gui.baseElement.visibility then
		self.gui:close();
	end;
end;

function CameradeTrabalho1:draw()
	if self.gui.baseElement.visibility then
		g_currentMission:addHelpButtonText(g_i18n:getText("DesactivarCameradeTrabalho1"), InputBinding.CameradeTrabalho1); 
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ActivarCameradeTrabalho1"), InputBinding.CameradeTrabalho1); 
	end;
end;