--
-- KamAZ45143
-- Specialization for KamAZ45143
--
-- @author  	
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--

KamAZ45143 = {};

function KamAZ45143.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function KamAZ45143:load(xmlFile)

-- fan

    self.fan = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fan#index"));
    self.fanRotation = 0;

-- motor

    self.motor1Active = false;
    self.motor2Active = false;		
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayKurs1 = 0;
    self.delayKurs2 = 0;
    self.delayOn = 0;
    self.delayOff = 0;
    self.deltafo = 0;

  local motor1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.motor1#index"));
    if motor1Node ~= nil then
        self.motor1 = {};
        self.motor1.node = motor1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor1#minRot"));
        self.motor1.minRot = {};
        self.motor1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor1#maxRot"));
        self.motor1.maxRot = {};
        self.motor1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.motor1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor1#rotTime"), 2)*70;
        self.motor1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor1#touchRotLimit"), 10));
    end;

  local motor2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.motor2#index"));
    if motor2Node ~= nil then
        self.motor2 = {};
        self.motor2.node = motor2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor2#minRot"));
        self.motor2.minRot = {};
        self.motor2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor2#maxRot"));
        self.motor2.maxRot = {};
        self.motor2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.motor2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor2#rotTime"), 2)*70;
        self.motor2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor2#touchRotLimit"), 10));
    end;
end;

function KamAZ45143:update(dt)

-- fan

if self.isMotorStarted and self.fan ~= nil then
    rotate(self.fan, 0, dt*0.09, 0);
end;

-- motor

        if self.motor1Active ~= nil and self.isMotorStarted then
			   if self.delayKurs1 >= 0 then
				self.delayKurs1 = self.delayKurs1 -dt;
			end;
			   if self.delayKurs2 >= 0 then
				self.delayKurs2 = self.delayKurs2 -dt;
			end;
			     if not self.motor1Max then
				   if self.delayKurs1 < 0 then
					self.delayKurs2 = 70;
					self.motor1Max = true;
					self.motor2Max = true;
				end;
			end;
			         if self.motor1Max then
				   if self.delayKurs2 < 0 then
					self.delayKurs1 = 70;
					self.motor1Max = false;
					self.motor2Max = false;
				end;
			end;
		else
			self.motor1Max = false;
			self.motor2Max = false;
		end;

      if self.motor1 ~= nil then
        	local x, y, z = getRotation(self.motor1.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.motor1.maxRot, self.motor1.minRot, 3, self.motor1.rotTime, dt, not self.motor1Max);
        	setRotation(self.motor1.node, unpack(newRot));
    	end;

      if self.motor2 ~= nil then
        	local x, y, z = getRotation(self.motor2.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.motor2.maxRot, self.motor2.minRot, 3, self.motor2.rotTime, dt, not self.motor2Max);
        	setRotation(self.motor2.node, unpack(newRot));
    	end;
end;

function KamAZ45143:delete()
end

function KamAZ45143:mouseEvent(posX, posY, isDown, isUp, button)
end

function KamAZ45143:keyEvent(unicode, sym, modifier, isDown)
end

function KamAZ45143:updateTick(dt)
end

function KamAZ45143:draw()
end