local metadata = {
"## Interface: FS15 1.3.0.1 1.3RC1",
"## Title: PigFillTrigger",
"## Notes: Trailer FillTrigger fr die SchweineMast",
"## Author: Marhu",
"## Version: 0.1.0-44",
"## Date: 08.07.2015",
"## Web: http://marhu.net"
}

local DebugEbene = 0;
local function getmdata(v) v="## "..v..": "; for i=1,table.getn(metadata) do local _,n=string.find(metadata[i],v);if n then return (string.sub (metadata[i], n+1)); end;end;end;
--print("Script "..(getmdata("Title")).." v"..(getmdata("Version")).." by "..(getmdata("Author")).." loaded! Support on "..(getmdata("Web")));
local function Debug(printDebug,...)
	if printDebug <= DebugEbene then
		local m,t,s,ts = "",type,select,tostring;
		for i = 1, s("#", ...) do if t(s(i, ...)) == "boolean" then m = m..(s(i, ...) and "true" or "false").." "; else m = m..ts(s(i, ...) or "nil").." "; end; end;
		print((getmdata("Title")).." v"..(getmdata("Version"))..": "..m);
end; end;

PigFillTrigger = {}
local PigFillTrigger_mt = Class(PigFillTrigger, Object);
InitObjectClass(PigFillTrigger, "PigFillTrigger");

function PigFillTrigger:new(isServer, isClient)
	local self = Object:new(isServer, isClient, PigFillTrigger_mt);
	self.rootNode = 0
	self.PigFillTriggerDirtyFlag = self:getNextDirtyFlag();
	
	return self;
end;

function PigFillTrigger:load(id,silo)
	
	self.rootNode = id
	self.Silo = silo;
	
	if self.isServer then
		self.triggerIds = {}
		local triggerRoot = Utils.indexToObject(id, getUserAttribute(id, "triggerIndex"))

		if triggerRoot == nil then
			triggerRoot = id
		end

		table.insert(self.triggerIds, triggerRoot)
		addTrigger(triggerRoot, "triggerCallback", self)

		for i = 1, 3, 1 do
			local child = getChildAt(triggerRoot, i - 1)

			table.insert(self.triggerIds, child)
			addTrigger(child, "triggerCallback", self)
		end
	end

	local fillTypesStr = getUserAttribute(id, "fillTypes")
	local priceMultipliersString = getUserAttribute(id, "priceMultipliers")
	if fillTypesStr ~= nil and fillTypesStr ~= "" then
		local fillTypes = Utils.splitString(" ", fillTypesStr)
		local multipliers = "";
		if priceMultipliersString ~= nil and priceMultipliersString ~= "" then
			multipliers = Utils.splitString(" ", priceMultipliersString)
		end
		self.fillTypes = {}
		self.priceMultipliers = {}
		for k, v in pairs(fillTypes) do
			local fillType = Fillable.fillTypeNameToInt[v]
			if fillType ~= nil then
				table.insert(self.fillTypes,fillType)
				self.selectedFillType = table.getn(self.fillTypes)
				if multipliers ~= "" then
					self.priceMultipliers[fillType] = tonumber(multipliers[k])
				end
			end
		end
	else
		Debug(-1,string.format("ERROR: missing fillTypes in %s",getName(id)));
	end

	if self.isClient then
		self.dropParticleSystems = {};
		self.siloFillSounds = {};
		local i = 1;
		while true do
			local dropParticleSystem = Utils.indexToObject(id, getUserAttribute(id, string.format("dropParticleSystemIndex%d",i)))
			if dropParticleSystem ~= nil then
				self.dropParticleSystems[i] = {};
				Utils.loadParticleSystemFromNode(dropParticleSystem, self.dropParticleSystems[i], false, true)
			else
				break;
			end
			i = i + 1;
		end
		local FillTypeSounds = false;
		local i = 1;
		while true do
			local fillSoundFilename = getUserAttribute(id, string.format("fillSoundFilename%d",i))
			if fillSoundFilename ~= nil then
				if fillSoundFilename ~= "" and fillSoundFilename ~= "none" then
					self.siloFillSounds[i] = {};
					fillSoundFilename = Utils.getFilename(fillSoundFilename, g_currentMission.baseDirectory)
					self.siloFillSounds[i] = createAudioSource("siloFillSound", fillSoundFilename, 30, 10, 1, 0)
					link(id, self.siloFillSounds[i])
					setVisibility(self.siloFillSounds[i], false)
					FillTypeSounds = true;
				end
			else
				break;
			end;
			i = i + 1;
		end;
		if FillTypeSounds ~= true then
			local fillSoundFilename = getUserAttribute(id, "fillSoundFilename");
			if fillSoundFilename ~= nil then
				if fillSoundFilename ~= "" and fillSoundFilename ~= "none" then
					fillSoundFilename = Utils.getFilename(fillSoundFilename, g_currentMission.baseDirectory)
					self.defaultFillSound = createAudioSource("siloFillSound", fillSoundFilename, 30, 10, 1, 0)
					link(id, self.defaultFillSound)
					setVisibility(self.defaultFillSound, false)
				end;
			end;
		end;
	end
	
	self.fill = 0
	self.siloTrailer = nil
	self.IsFilling = false
	self.isEnabled = true
	
	return true;
end;

function PigFillTrigger:delete()
	if self.isClient then
		if self.siloFillSounds ~= nil then
			for _,Sound in pairs(self.siloFillSounds) do
				delete(Sound)
			end;
		end
		if self.defaultFillSound ~= nil then
			delete(self.defaultFillSound)
		end
		for i = 1, table.getn(self.dropParticleSystems) do
			if entityExists(self.dropParticleSystems[i][1].shape) then
				Utils.deleteParticleSystem(self.dropParticleSystems[i]);
			end;
		end
	end

	if self.isServer then
		for i = 1, table.getn(self.triggerIds), 1 do
			removeTrigger(self.triggerIds[i])
		end
	end

	delete(self.rootNode)
end;

function PigFillTrigger:writeStream(streamId, connection)
	if not connection:getIsServer() then
		if self.TrailerSend ~= nil then
			streamWriteInt32(streamId, networkGetObjectId(self.TrailerSend))
		else
			streamWriteInt32(streamId, 0)
		end
	end
end

function PigFillTrigger:readStream(streamId, connection)
	if connection:getIsServer() then
		local Trailer = streamReadInt32(streamId)

		if Trailer ~= 0 then
			self.siloTrailer = networkGetObject(Trailer)
		else
			self.siloTrailer = nil
		end
	end
end

function PigFillTrigger:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		if self.TrailerSend ~= nil then
			streamWriteInt32(streamId, networkGetObjectId(self.TrailerSend))
		else
			streamWriteInt32(streamId, 0)
		end
	end
end;

function PigFillTrigger:readUpdateStream(streamId, timestamp, connection)

	if connection:getIsServer() then
		local Trailer = streamReadInt32(streamId)

		if Trailer ~= 0 then
			self.siloTrailer = networkGetObject(Trailer)
		else
			self.siloTrailer = nil
		end
	end
end;

function PigFillTrigger:update(dt)
	
	local trailer = self.siloTrailer;
	local fillType = self.fillTypes[self.selectedFillType];
	
	if self.isServer then
		if self.fill >= 4 and trailer ~= nil then
			if self.IsFilling then
				trailer:resetFillLevelIfNeeded(fillType);
				local fillLevel = trailer:getFillLevel(fillType);
				local siloAmount = 10;
				if self.Silo and self.Silo.getSiloAmount then
					siloAmount = self.Silo:getSiloAmount(fillType)
				end
				if siloAmount > 0 and trailer:allowFillType(fillType, false) then
					trailer.LoadTime = (trailer.LoadTime or 0) + dt
					if trailer.LoadTime >= (trailer.CargoUnloadTime or 1000) then
						trailer.LoadTime = 0
						local deltaFillLevel = 1
						trailer:setFillLevel(fillLevel+deltaFillLevel, fillType);
						local newFillLevel = trailer:getFillLevel(fillType);
							
						if fillLevel ~= newFillLevel then
							if self.Silo and self.Silo.setSiloAmount then
								self.Silo:setSiloAmount(fillLevel-newFillLevel,fillType)
							else
								local desc = Fillable.fillTypeIndexToDesc[fillType]
								local priceMultiplier = (self.priceMultipliers[fillType] or 0)
								local difficultyMultiplier = math.max((g_currentMission.missionStats.difficulty - 3)*2, 1)
								local money = desc.pricePerLiter*priceMultiplier*difficultyMultiplier*(newFillLevel-fillLevel)
								g_currentMission:addSharedMoney(-money, "newAnimalsCost")
							end;
							self:setIsFilling(true,fillType)
						else -- trailer is full
							self:setIsFilling(false);
						end;
					end
				else -- silo is empty or trailer does not support fill type
					self:setIsFilling(false);
				end;
			end;
		elseif self.IsFilling then
			self:setIsFilling(false);
		end;
			
		if trailer ~= self.TrailerSend then
			self.TrailerSend = trailer
			self.SendUpdate = true;
		end
	end;

	
	if self.isClient then
		if trailer ~= nil and trailer:getRootAttacherVehicle() == g_currentMission.controlledVehicle then
			
			if self.IsFilling then
				g_currentMission:addHelpButtonText(g_i18n:getText("siloStopFilling"),InputBinding.ACTIVATE_OBJECT);
				if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
					self:setIsFilling(false,self.fillTypes[self.selectedFillType])
				end;
			else
				if trailer.fillLevel == 0 or trailer.currentFillType == fillType then
					g_currentMission:addHelpButtonText(g_i18n:getText("siloStartFilling"),InputBinding.ACTIVATE_OBJECT);
					if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
						self:setIsFilling(true,fillType)
					end;
				else
					self:setIsFilling(self.IsFilling,trailer.currentFillType)
				end;
				if trailer.fillLevel == 0 then
					if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
						local newSelectedFillType = self.selectedFillType + 1;
						if newSelectedFillType > table.getn(self.fillTypes) then newSelectedFillType = 1 end;
						self:setIsFilling(self.IsFilling,self.fillTypes[newSelectedFillType])
					end;
				end;
				local desc = Fillable.fillTypeIndexToDesc[fillType];
				local text = desc.nameI18N;
				if self.Silo == nil then
					if self.priceMultipliers and self.priceMultipliers[fillType] then
						local priceMultiplier = self.priceMultipliers[fillType];
						local difficultyMultiplier = math.max((g_currentMission.missionStats.difficulty - 3)*2, 1);
						local money = desc.pricePerLiter*priceMultiplier*difficultyMultiplier;
						text = string.format("%s %d %s",desc.nameI18N, money, g_i18n:getCurrencySymbol(true))
					end;
				elseif self.Silo.getSiloAmount then
					text = text..string.format(" %d",self.Silo:getSiloAmount(fillType))
				end
				g_currentMission:addHelpButtonText(text,InputBinding.IMPLEMENT_EXTRA3);
			end;
		end;
	end
	
	if self.SendUpdate then
		self.SendUpdate = nil
		self:raiseDirtyFlags(self.PigFillTriggerDirtyFlag);
	end
end;

function PigFillTrigger:updateTick(dt)
	if self.isServer and self.SendUpdate then
		self.SendUpdate = nil
		self:raiseDirtyFlags(self.PigFillTriggerDirtyFlag);
	end
end;

function PigFillTrigger:setIsFilling(IsFilling, fillType, noEventSend)
	PigFillTriggerSetFillingEvent.sendEvent(self, IsFilling, fillType, noEventSend);
	for i=1,table.getn(self.fillTypes) do
		if fillType == self.fillTypes[i] then
			self.selectedFillType = i;
			break;
		end
	end
	if IsFilling then
		self:startFill(fillType)
	else
		self:stopFill()
	end
end

function PigFillTrigger:stopFill()
	if self.IsFilling then
		self.IsFilling = false
		
		if self.isClient then
			if self.siloFillSoundEnabled then
				if self.defaultFillSound ~= nil then
					setVisibility(self.defaultFillSound, false)
				elseif self.siloFillSounds ~= nil then
					for _,Sound in pairs(self.siloFillSounds) do
						setVisibility(Sound, false)
					end;
				end
				self.siloFillSoundEnabled = false
			end;
			
			for i=1,table.getn(self.dropParticleSystems) do
				Utils.setEmittingState(self.dropParticleSystems[i], false);
			end;
		end
	end
end

function PigFillTrigger:startFill(fillType)
	if not self.IsFilling then
		self.IsFilling = true

		if self.isClient then
			if not self.siloFillSoundEnabled then
				if self.defaultFillSound ~= nil then
					setVisibility(self.defaultFillSound, true)
				elseif self.siloFillSounds ~= nil then
					if self.siloFillSounds[self.selectedFillType] ~= nil then
						setVisibility(self.siloFillSounds[self.selectedFillType], true)
					end;
				end;
				self.siloFillSoundEnabled = true
			end;

			Utils.setEmittingState(self.dropParticleSystems[self.selectedFillType], true)
		end
	end
end

function PigFillTrigger:getIsValidTrailer(trailer)
	for _, fillType in pairs(self.fillTypes) do
		if trailer.allowFillType(trailer, fillType, false) then
			return true
		end
	end
	return false
end

function PigFillTrigger:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	assert(self.isServer)

	if self.isEnabled then
		local trailer = g_currentMission.objectToTrailer[otherShapeId]

		if trailer ~= nil then
			if onEnter then
				if self.getIsValidTrailer(self, trailer) then
					self.fill = self.fill + 1
					self.siloTrailer = trailer
				end
			elseif onLeave then
				self.fill = math.max(self.fill - 1, 0)
				self.siloTrailer = nil

				self:setIsFilling(false, self.fillTypes[self.selectedFillType])
			end
		end
	end;
end
 
 -- Event Set IsFilling and fillType --

PigFillTriggerSetFillingEvent = {};
PigFillTriggerSetFillingEvent_mt = Class(PigFillTriggerSetFillingEvent, Event);

InitEventClass(PigFillTriggerSetFillingEvent, "PigFillTriggerSetFillingEvent");

function PigFillTriggerSetFillingEvent:emptyNew()
    local self = Event:new(PigFillTriggerSetFillingEvent_mt);
    return self;
end;

function PigFillTriggerSetFillingEvent:new(object, IsFilling, fillType)
	local self = PigFillTriggerSetFillingEvent:emptyNew()
	self.object = object;
	self.IsFilling = IsFilling;
	self.fillType = fillType;
	return self;
end;

function PigFillTriggerSetFillingEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.IsFilling = streamReadBool(streamId);
	self.fillType = streamReadUIntN(streamId, Fillable.sendNumBits);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function PigFillTriggerSetFillingEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.IsFilling);
	streamWriteUIntN(streamId, self.fillType, Fillable.sendNumBits)
end;

function PigFillTriggerSetFillingEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:setIsFilling(self.IsFilling, self.fillType, true);
	end;
end;

function PigFillTriggerSetFillingEvent.sendEvent(object, IsFilling, fillType, noEventSend)
	if IsFilling ~= object.IsFilling or fillType ~= object.fillTypes[object.selectedFillType] then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(PigFillTriggerSetFillingEvent:new(object, IsFilling, fillType), nil, nil, object);
			else
				g_client:getServerConnection():sendEvent(PigFillTriggerSetFillingEvent:new(object, IsFilling, fillType));
			end;
		end;
	end;
end;
