local metadata = {
"## Interface: FS15 1.3.0.1 1.3RC1",
"## Title: DoorTrigger",
"## Notes: DoorTrigger von der SchweineMast",
"## Author: Marhu",
"## Version: 1.2.5-9",
"## Date: 08.07.2015",
"## Web: http://marhu.net"
}

local DebugEbene = 0;
local function getmdata(v) v="## "..v..": "; for i=1,table.getn(metadata) do local _,n=string.find(metadata[i],v);if n then return (string.sub (metadata[i], n+1)); end;end;end;
--print("Script "..(getmdata("Title")).." v"..(getmdata("Version")).." by "..(getmdata("Author")).." loaded! Support on "..(getmdata("Web")));
local function Debug(printDebug,...)
	if printDebug <= DebugEbene then
		local m,t,s,ts = "",type,select,tostring;
		for i = 1, s("#", ...) do if t(s(i, ...)) == "boolean" then m = m..(s(i, ...) and "true" or "false").." "; else m = m..ts(s(i, ...) or "nil").." "; end; end;
		print((getmdata("Title")).." v"..(getmdata("Version"))..": "..m);
end; end;

DoorTrigger = {}
DoorTrigger.ModDir = g_currentModDirectory
local DoorTrigger_mt = Class(DoorTrigger);
InitObjectClass(DoorTrigger, "DoorTrigger");

function DoorTrigger.onCreate(id)
   g_currentMission:addUpdateable(DoorTrigger:new(id));

end;

g_onCreateUtil.addOnCreateFunction("DoorTrigger", DoorTrigger.onCreate);

function DoorTrigger:new(nodeId)
	local self = {};
    setmetatable(self, DoorTrigger_mt);
	
		self.Doors = {}
		self.DoorNodes = {}
		local doorGroup = nodeId;
		local doorIndex = getUserAttribute(nodeId, "DoorIndex");
		if doorIndex then
			doorGroup = Utils.indexToObject(nodeId, doorIndex);
		end;
		local numChildren = getNumOfChildren(doorGroup);
		for i=1,numChildren do
			local Child = getChildAt(doorGroup, i-1)
			self.Doors[i] = {}
			local trans = getUserAttribute(Child, "Trans")
			if trans then
				local x,y,z = getTranslation(Child)
				self.Doors[i].minTrans = math.min(z,trans)
				self.Doors[i].maxTrans = math.max(z,trans)
				self.Doors[i].dirTrans = trans > self.Doors[i].minTrans and 1 or -1;
				local transTime = Utils.getNoNil(getUserAttribute(Child, "TransTime"),1);
				self.Doors[i].transTime = ((self.Doors[i].maxTrans-self.Doors[i].minTrans) / transTime) * 0.001
			end
			self.Doors[i].Trans = self.Doors[i].minTrans or 0;
			
			local rot = getUserAttribute(Child, "Rot")
			if rot then
				local x,y,z = getRotation(Child)
				self.Doors[i].minRot = math.min(x,rot)
				self.Doors[i].maxRot = math.max(x,rot)
				self.Doors[i].dirRot = rot > self.Doors[i].minRot and 1 or -1;
				local RotTime = Utils.getNoNil(getUserAttribute(Child, "RotTime"),1);
				self.Doors[i].RotTime = ((self.Doors[i].maxRot-self.Doors[i].minRot) / RotTime) * 0.001
			end
			self.Doors[i].Rot = self.Doors[i].minRot or 0;
			
			self.Doors[i].door = Child
			self.DoorNodes[Child] = self.Doors[i]
		end
		
		local TriggerIndex = getUserAttribute(nodeId, "TriggerIndex");
		if TriggerIndex ~= nil then
			self.triggerId = Utils.indexToObject(nodeId,TriggerIndex);
			addTrigger(self.triggerId, "doorTriggerCallback", self);
		end
		
		self.entred = 0;
		
    return self;
end;

function DoorTrigger:delete()
	if self.triggerId then
		
		removeTrigger(self.triggerId);

	end
end;

function DoorTrigger:update(dt)
    if self.Doors then
		for i=1, table.getn(self.Doors) do
			local oldTrans = self.Doors[i].Trans;
			local oldRot = self.Doors[i].Rot;
			if (self.entred > 0) then
				if self.Doors[i].dirTrans == 1 then
					if self.Doors[i].maxTrans and self.Doors[i].Trans < self.Doors[i].maxTrans then
					self.Doors[i].Trans = math.min(self.Doors[i].Trans + dt*self.Doors[i].transTime, self.Doors[i].maxTrans);
					end;
				else
					if self.Doors[i].minTrans and self.Doors[i].Trans > self.Doors[i].minTrans then
						self.Doors[i].Trans = math.max(self.Doors[i].Trans - dt*self.Doors[i].transTime, self.Doors[i].minTrans);
					end;
				end
				if self.Doors[i].dirRot == 1 then
					if self.Doors[i].maxRot and self.Doors[i].Rot < self.Doors[i].maxRot then
						self.Doors[i].Rot = math.min(self.Doors[i].Rot + dt*self.Doors[i].RotTime, self.Doors[i].maxRot);
					end;
				else
					if self.Doors[i].minRot and self.Doors[i].Rot > self.Doors[i].minRot then
						self.Doors[i].Rot = math.max(self.Doors[i].Rot - dt*self.Doors[i].RotTime, self.Doors[i].minRot);
					end;
				end				
			elseif (self.entred <= 0) then
				if self.Doors[i].dirTrans == -1 then
					if self.Doors[i].maxTrans and self.Doors[i].Trans < self.Doors[i].maxTrans then
					self.Doors[i].Trans = math.min(self.Doors[i].Trans + dt*self.Doors[i].transTime, self.Doors[i].maxTrans);
					end;
				else
					if self.Doors[i].minTrans and self.Doors[i].Trans > self.Doors[i].minTrans then
						self.Doors[i].Trans = math.max(self.Doors[i].Trans - dt*self.Doors[i].transTime, self.Doors[i].minTrans);
					end;
				end
				if self.Doors[i].dirRot == -1 then
					if self.Doors[i].maxRot and self.Doors[i].Rot < self.Doors[i].maxRot then
						self.Doors[i].Rot = math.min(self.Doors[i].Rot + dt*self.Doors[i].RotTime, self.Doors[i].maxRot);
					end;
				else
					if self.Doors[i].minRot and self.Doors[i].Rot > self.Doors[i].minRot then
						self.Doors[i].Rot = math.max(self.Doors[i].Rot - dt*self.Doors[i].RotTime, self.Doors[i].minRot);
					end;
				end		
			end;

			if oldTrans ~= self.Doors[i].Trans then
				local x, y, z = getTranslation(self.Doors[i].door);
				setTranslation(self.Doors[i].door, x, y, self.Doors[i].Trans);
			end;
			if oldRot ~= self.Doors[i].Rot then
				local x, y, z = getRotation(self.Doors[i].door);
				setRotation(self.Doors[i].door, math.rad(self.Doors[i].Rot), y, z);
			end
		end;
	end;
end;

function DoorTrigger:doorTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	
	if self.triggerId == triggerId and self.DoorNodes[otherId] == nil then
		if onEnter then
			self.entred = self.entred + 1
		else -- onLeave
			self.entred = math.max(self.entred - 1,0)
		end;
	end;

end;

