--
-- RivalsBomb - New Indoor Sound Specialization Steyr 8090 Sk2
--

indoorSound8090Sk2 = {};
indoorSound8090Sk2.modDir = g_currentModDirectory;

function indoorSound8090Sk2.prerequisitesPresent(specializations)

    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function indoorSound8090Sk2:load(xmlFile)

	self.internalSound = {};
	self.internalSound.factor = 0.5;
	self.internalSound.doorOpenFactor = 0.9;
	self.internalSound.sideWindowOpenFactor = 0.8;
	self.internalSound.backWindowOpenFactor = 0.65;
	self.internalSound.dCwasTurnedOn = false;
end;	
	
function indoorSound8090Sk2:delete()
end;
function indoorSound8090Sk2:mouseEvent(posX, posY, isDown, isUp, button)
end;
function indoorSound8090Sk2:keyEvent(unicode, sym, modifier, isDown)
end;
function indoorSound8090Sk2:update(dt)

	if self.isEntered then
		if g_currentMission.driveControl ~= nil and g_currentMission.driveControl.useModules.inDoorSound then
			self.internalSound.dCwasTurnedOn = true;
			g_currentMission.driveControl.useModules.inDoorSound = false;
		end;
		
		if self:getIsActiveForSound() then
			if self.sampleMotor ~= nil then
				local samples = {self.sampleMotor, self.sampleMotorRun2, self.sampleMotorStart, self.sampleMotorStop, self.sampleThreshingStop, self.sampleHonk, self.sampleRefuel, self.samplePipe, self.sampleThreshingStart, self.sampleReverseDrive, self.sampleThreshing, self.sampleCompression, self.sampleHydraulic, self.sampleCompressedAir, self.sampleCylinderedHydraulic};
				for _,sample in pairs(samples) do
					if sample ~= nil then
						local targetVolume = sample.volume;
						if self.camIndex == 2 and self.animations["ScheibeRechts"].currentTime == 0 and self.animations["ScheibeLinks"].currentTime == 0 and self.animations["Frontscheibe"].currentTime == 0 and self.animations["Heckfenster"].currentTime == 0 and self.animations["TuerLinks"].currentTime == 0 and self.animations["TuerRechts"].currentTime == 0 then
							targetVolume = self.internalSound.factor*targetVolume;
						elseif self.camIndex == 2 and self.animations["Frontscheibe"].currentTime ~= 0 then
							targetVolume = sample.volume;
						elseif self.camIndex == 2 and (self.animations["TuerLinks"].currentTime ~= 0 or self.animations["TuerRechts"].currentTime ~= 0) then
							targetVolume = self.internalSound.doorOpenFactor*targetVolume;
						elseif self.camIndex == 2 and (self.animations["ScheibeRechts"].currentTime ~= 0 or self.animations["ScheibeLinks"].currentTime ~= 0) then
							targetVolume = self.internalSound.sideWindowOpenFactor*targetVolume;
						elseif self.camIndex == 2 and self.animations["Heckfenster"].currentTime ~= 0 then
							targetVolume = self.internalSound.backWindowOpenFactor*targetVolume;
						end;
						if sample.sample ~= nil then --or volume ~= targetVolume then
							setSampleVolume(sample.sample,targetVolume)
						end;
					end;	
				end;
			end;
		end;
	end;

	if self.isEntered then
		local input = 0;
		if self.axisForward ~= nil then
			input = self.axisForward;
		end;
	
		if self.sampleMotorRun ~= nil then
			local roundPerMinute = 620;
			if self.lastRoundPerMinute ~= nil and self.motor.lastMotorRpm ~= nil then
				roundPerMinute = self.lastRoundPerMinute*0.9 + (1-0.9)*(self.motor.lastMotorRpm-self.motor.minRpm);
			end;
			local rpmVolume = 0.8;
	
			if math.abs(input) > 0.01 then -- or self.motor.speedLevel ~= 0
				if self.camIndex == 2 and self.animations["ScheibeRechts"].currentTime == 0 and self.animations["ScheibeLinks"].currentTime == 0 and self.animations["Frontscheibe"].currentTime == 0 and self.animations["Heckfenster"].currentTime == 0 and self.animations["TuerLinks"].currentTime == 0 and self.animations["TuerRechts"].currentTime == 0 then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8))*self.internalSound.factor;
				elseif self.camIndex == 2 and self.animations["Frontscheibe"].currentTime ~= 0 then
					rpmVolume = Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8);
				elseif self.camIndex == 2 and (self.animations["TuerLinks"].currentTime ~= 0 or self.animations["TuerRechts"].currentTime ~= 0) then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8))*self.internalSound.doorOpenFactor;
				elseif self.camIndex == 2 and (self.animations["ScheibeRechts"].currentTime ~= 0 or self.animations["ScheibeLinks"].currentTime ~= 0) then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8))*self.internalSound.sideWindowOpenFactor;
				elseif self.camIndex == 2 and self.animations["Heckfenster"].currentTime ~= 0 then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/(self.motor.maxRpm - self.motor.minRpm), 0.0, 0.8))*self.internalSound.backWindowOpenFactor;
				end;
			else
				if self.camIndex == 2 and self.animations["ScheibeRechts"].currentTime == 0 and self.animations["ScheibeLinks"].currentTime == 0 and self.animations["Frontscheibe"].currentTime == 0 and self.animations["Heckfenster"].currentTime == 0 and self.animations["TuerLinks"].currentTime == 0 and self.animations["TuerRechts"].currentTime == 0 then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8))*self.internalSound.factor;
				elseif self.camIndex == 2 and self.animations["Frontscheibe"].currentTime ~= 0 then
					rpmVolume = Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8);
				elseif self.camIndex == 2 and (self.animations["TuerLinks"].currentTime ~= 0 or self.animations["TuerRechts"].currentTime ~= 0) then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8))*self.internalSound.doorOpenFactor;
				elseif self.camIndex == 2 and (self.animations["ScheibeRechts"].currentTime ~= 0 or self.animations["ScheibeLinks"].currentTime ~= 0) then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8))*self.internalSound.sideWindowOpenFactor;
				elseif self.camIndex == 2 and self.animations["Heckfenster"].currentTime ~= 0 then
					rpmVolume = (Utils.clamp(math.abs(roundPerMinute)/((self.motor.maxRpm - self.motor.minRpm)*2), 0.0, 0.8))*self.internalSound.backWindowOpenFactor;
				end;
			end;
			if self.camIndex == 2 then
				setSampleVolume(self.sampleMotorRun.sample, rpmVolume);
			end;
		end;
	else
		if g_currentMission.driveControl ~= nil and not g_currentMission.driveControl.useModules.inDoorSound and self.internalSound.dCwasTurnedOn then
			g_currentMission.driveControl.useModules.inDoorSound = true;
		end;
	end;
end;

function indoorSound8090Sk2:draw()	
end;